/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleEvent;
import org.jhotdraw.draw.HandleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandle
implements Handle,
FigureListener {
    private Figure owner;
    protected DrawingView view;
    protected EventListenerList listenerList = new EventListenerList();
    private Rectangle bounds;

    public AbstractHandle(Figure figure) {
        this.owner = figure;
        figure.addFigureListener(this);
    }

    protected int getHandlesize() {
        return 7;
    }

    @Override
    public void addHandleListener(HandleListener handleListener) {
        this.listenerList.add(HandleListener.class, handleListener);
    }

    @Override
    public void removeHandleListener(HandleListener handleListener) {
        this.listenerList.remove(HandleListener.class, handleListener);
    }

    @Override
    public Figure getOwner() {
        return this.owner;
    }

    @Override
    public void setView(DrawingView drawingView) {
        this.view = drawingView;
    }

    protected void fireAreaInvalidated(Rectangle rectangle) {
        HandleEvent handleEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HandleListener.class) continue;
            if (handleEvent == null) {
                handleEvent = new HandleEvent(this, rectangle);
            }
            ((HandleListener)objectArray[i + 1]).areaInvalidated(handleEvent);
        }
    }

    protected void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        this.view.getDrawing().fireUndoableEditHappened(undoableEdit);
    }

    protected void fireHandleRequestRemove(Rectangle rectangle) {
        HandleEvent handleEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HandleListener.class) continue;
            if (handleEvent == null) {
                handleEvent = new HandleEvent(this, rectangle);
            }
            ((HandleListener)objectArray[i + 1]).handleRequestRemove(handleEvent);
        }
    }

    protected void fireHandleRequestSecondaryHandles() {
        HandleEvent handleEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HandleListener.class) continue;
            if (handleEvent == null) {
                handleEvent = new HandleEvent(this, null);
            }
            ((HandleListener)objectArray[i + 1]).handleRequestSecondaryHandles(handleEvent);
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.drawCircle(graphics2D, Color.white, Color.black);
    }

    protected void drawCircle(Graphics2D graphics2D, Color color, Color color2) {
        Rectangle rectangle = this.getBounds();
        graphics2D.setColor(color);
        graphics2D.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(color2);
        graphics2D.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void drawRectangle(Graphics2D graphics2D, Color color, Color color2) {
        Rectangle rectangle = this.getBounds();
        graphics2D.setColor(color);
        graphics2D.fill(rectangle);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(color2);
        graphics2D.draw(rectangle);
    }

    protected void drawDiamond(Graphics2D graphics2D, Color color, Color color2) {
        Rectangle rectangle = this.getBounds();
        rectangle.grow(1, 1);
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x + rectangle.width / 2, rectangle.y);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
        polygon.addPoint(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
        polygon.addPoint(rectangle.x, rectangle.y + rectangle.height / 2);
        polygon.addPoint(rectangle.x + rectangle.width / 2, rectangle.y);
        graphics2D.setColor(color);
        graphics2D.fill(polygon);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(color2);
        graphics2D.draw(polygon);
    }

    @Override
    public boolean contains(Point point) {
        return this.getBounds().contains(point);
    }

    @Override
    public void invalidate() {
        this.fireAreaInvalidated(this.getDrawBounds());
    }

    @Override
    public void dispose() {
        this.owner.removeFigureListener(this);
        this.owner = null;
    }

    @Override
    public void figureAreaInvalidated(FigureEvent figureEvent) {
        this.updateBounds();
    }

    @Override
    public void figureAdded(FigureEvent figureEvent) {
    }

    @Override
    public void figureRemoved(FigureEvent figureEvent) {
    }

    @Override
    public void figureRequestRemove(FigureEvent figureEvent) {
    }

    @Override
    public void figureChanged(FigureEvent figureEvent) {
        this.updateBounds();
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(13);
    }

    @Override
    public boolean isCombinableWith(Handle handle) {
        return this.getClass().isAssignableFrom(handle.getClass());
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public final Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = this.basicGetBounds();
        }
        return (Rectangle)this.bounds.clone();
    }

    @Override
    public Rectangle getDrawBounds() {
        Rectangle rectangle = this.getBounds();
        rectangle.grow(2, 2);
        return rectangle;
    }

    protected abstract Rectangle basicGetBounds();

    protected void updateBounds() {
        Rectangle rectangle = this.basicGetBounds();
        if (this.bounds == null || !rectangle.equals(this.bounds)) {
            if (this.bounds != null) {
                this.fireAreaInvalidated(this.getDrawBounds());
            }
            this.bounds = rectangle;
            this.fireAreaInvalidated(this.getDrawBounds());
        }
    }

    @Override
    public void trackDoubleClick(Point point, int n) {
    }

    @Override
    public void figureAttributeChanged(FigureEvent figureEvent) {
    }

    @Override
    public void viewTransformChanged() {
        this.bounds = null;
    }

    @Override
    public Collection<Handle> createSecondaryHandles() {
        return Collections.emptyList();
    }
}

