/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.geom.Geom;

public abstract class AbstractLineDecoration
implements LineDecoration {
    private boolean isFilled;
    private boolean isStroked;
    private boolean isSolid;

    public AbstractLineDecoration(boolean bl, boolean bl2, boolean bl3) {
        this.isFilled = bl;
        this.isStroked = bl2;
        this.isSolid = bl3;
    }

    protected boolean isFilled() {
        return this.isFilled;
    }

    protected boolean isStroked() {
        return this.isStroked;
    }

    protected boolean isSolid() {
        return this.isSolid;
    }

    public void draw(Graphics2D graphics2D, Figure figure, Point2D.Double double_, Point2D.Double double_2) {
        Color color;
        GeneralPath generalPath = this.getTransformedDecoratorPath(figure, double_, double_2);
        if (this.isFilled && (color = this.isSolid ? AttributeKeys.STROKE_COLOR.get(figure) : AttributeKeys.FILL_COLOR.get(figure)) != null) {
            graphics2D.setColor(color);
            graphics2D.fill(generalPath);
        }
        if (this.isStroked && (color = AttributeKeys.STROKE_COLOR.get(figure)) != null) {
            graphics2D.setColor(color);
            graphics2D.setStroke(AttributeKeys.getStroke(figure));
            graphics2D.draw(generalPath);
        }
    }

    public Rectangle2D.Double getDrawBounds(Figure figure, Point2D.Double double_, Point2D.Double double_2) {
        GeneralPath generalPath = this.getTransformedDecoratorPath(figure, double_, double_2);
        Rectangle2D rectangle2D = generalPath.getBounds2D();
        Rectangle2D.Double double_3 = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        if (this.isStroked) {
            double d = AttributeKeys.STROKE_WIDTH.get(figure);
            int n = AttributeKeys.STROKE_JOIN.get(figure);
            float f = (float)(AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(figure) * d);
            int n2 = n == 0 ? (int)(1.0 + d / 2.0 * (double)f) : (int)(1.0 + d / 2.0);
            Geom.grow(double_3, n2, n2);
        }
        return double_3;
    }

    public double getDecorationRadius(Figure figure) {
        double d = AttributeKeys.STROKE_WIDTH.get(figure);
        double d2 = d > 1.0 ? 1.0 + (d - 1.0) / 2.0 : 1.0;
        return this.getDecoratorPathRadius(figure) * d2;
    }

    private GeneralPath getTransformedDecoratorPath(Figure figure, Point2D.Double double_, Point2D.Double double_2) {
        GeneralPath generalPath = this.getDecoratorPath(figure);
        double d = AttributeKeys.STROKE_WIDTH.get(figure);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(double_.x, double_.y);
        affineTransform.rotate(Math.atan2(double_.x - double_2.x, double_2.y - double_.y));
        if (d > 1.0) {
            affineTransform.scale(1.0 + (d - 1.0) / 2.0, 1.0 + (d - 1.0) / 2.0);
        }
        generalPath.transform(affineTransform);
        return generalPath;
    }

    protected void setFilled(boolean bl) {
        this.isFilled = bl;
    }

    protected void setStroked(boolean bl) {
        this.isStroked = bl;
    }

    protected void setSolid(boolean bl) {
        this.isSolid = bl;
    }

    protected abstract GeneralPath getDecoratorPath(Figure var1);

    protected abstract double getDecoratorPathRadius(Figure var1);
}

