/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.undo.CompositeEdit;

public abstract class AbstractTool
implements Tool {
    private boolean isActive;
    protected boolean isWorking;
    protected DrawingEditor editor;
    protected Point anchor = new Point();
    protected EventListenerList listenerList = new EventListenerList();

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.remove(UndoableEditListener.class, undoableEditListener);
    }

    public void activate(DrawingEditor drawingEditor) {
        this.editor = drawingEditor;
        this.isActive = true;
    }

    public void deactivate(DrawingEditor drawingEditor) {
        this.editor = drawingEditor;
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected DrawingView getView() {
        return this.editor.getView();
    }

    protected DrawingEditor getEditor() {
        return this.editor;
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected Point2D.Double viewToDrawing(Point point) {
        return this.constrainPoint(this.getView().viewToDrawing(point));
    }

    protected Point2D.Double constrainPoint(Point point) {
        return this.constrainPoint(this.getView().viewToDrawing(point));
    }

    protected Point2D.Double constrainPoint(Point2D.Double double_) {
        return this.getView().getConstrainer().constrainPoint(double_);
    }

    public void editDelete() {
        this.getView().getDrawing().removeAll(this.getView().getSelectedFigures());
    }

    public void editCut() {
    }

    public void editCopy() {
    }

    public void editDuplicate() {
    }

    public void editPaste() {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.fireToolDone();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() instanceof Container) {
            this.editor.setView(this.editor.findView((Container)keyEvent.getSource()));
        }
        switch (keyEvent.getKeyCode()) {
            case 8: 
            case 127: {
                this.editDelete();
                break;
            }
            case 65: {
                if ((keyEvent.getModifiers() & 6) == 0) break;
                this.getView().addToSelection(this.getView().getDrawing().getFigures());
                break;
            }
            case 37: {
                Collection<Figure> collection = this.getView().getSelectedFigures();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(-1.0, 0.0);
                for (Figure figure : collection) {
                    figure.willChange();
                    figure.basicTransform(affineTransform);
                    figure.changed();
                }
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(collection, affineTransform));
                break;
            }
            case 39: {
                Collection<Figure> collection = this.getView().getSelectedFigures();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(1.0, 0.0);
                for (Figure figure : collection) {
                    figure.willChange();
                    figure.basicTransform(affineTransform);
                    figure.changed();
                }
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(collection, affineTransform));
                break;
            }
            case 38: {
                Collection<Figure> collection = this.getView().getSelectedFigures();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, -1.0);
                for (Figure figure : collection) {
                    figure.willChange();
                    figure.basicTransform(affineTransform);
                    figure.changed();
                }
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(collection, affineTransform));
                break;
            }
            case 40: {
                Collection<Figure> collection = this.getView().getSelectedFigures();
                CompositeEdit compositeEdit = new CompositeEdit("Figur(en) verschieben");
                this.getDrawing().fireUndoableEditHappened(compositeEdit);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, 1.0);
                for (Figure figure : collection) {
                    figure.willChange();
                    figure.basicTransform(affineTransform);
                    figure.changed();
                }
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(collection, affineTransform));
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.isWorking) {
            this.editor.setView(this.editor.findView((Container)mouseEvent.getSource()));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        DrawingView drawingView = this.editor.findView((Container)mouseEvent.getSource());
        drawingView.requestFocus();
        this.anchor = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.isWorking = true;
        this.fireToolStarted(drawingView);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.isWorking = false;
    }

    public void addToolListener(ToolListener toolListener) {
        this.listenerList.add(ToolListener.class, toolListener);
    }

    public void removeToolListener(ToolListener toolListener) {
        this.listenerList.remove(ToolListener.class, toolListener);
    }

    protected void fireToolStarted(DrawingView drawingView) {
        ToolEvent toolEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ToolListener.class) continue;
            if (toolEvent == null) {
                toolEvent = new ToolEvent(this, drawingView, new Rectangle(0, 0, -1, -1));
            }
            ((ToolListener)objectArray[i + 1]).toolStarted(toolEvent);
        }
    }

    protected void fireToolDone() {
        ToolEvent toolEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ToolListener.class) continue;
            if (toolEvent == null) {
                toolEvent = new ToolEvent(this, this.getView(), new Rectangle(0, 0, -1, -1));
            }
            ((ToolListener)objectArray[i + 1]).toolDone(toolEvent);
        }
    }

    protected void fireAreaInvalidated(Rectangle2D.Double double_) {
        Point point = this.getView().drawingToView(new Point2D.Double(double_.x, double_.y));
        Point point2 = this.getView().drawingToView(new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
        this.fireAreaInvalidated(new Rectangle(point.x, point.y, point2.x - point.x, point2.y - point.y));
    }

    protected void fireAreaInvalidated(Rectangle rectangle) {
        ToolEvent toolEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ToolListener.class) continue;
            if (toolEvent == null) {
                toolEvent = new ToolEvent(this, this.getView(), rectangle);
            }
            ((ToolListener)objectArray[i + 1]).areaInvalidated(toolEvent);
        }
    }

    public void draw(Graphics2D graphics2D) {
    }

    public void updateCursor(DrawingView drawingView, Point point) {
        Handle handle = drawingView.findHandle(point);
        if (handle != null) {
            drawingView.setCursor(handle.getCursor());
        } else {
            Figure figure = drawingView.findFigure(point);
            if (figure != null) {
                drawingView.setCursor(figure.getCursor(drawingView.viewToDrawing(point)));
            } else {
                drawingView.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

