/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.lang.reflect.TypeVariable;
import org.jhotdraw.draw.Figure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeKey<T> {
    private String key;
    private T defaultValue;
    private boolean isNullValueAllowed;

    public AttributeKey(String string) {
        this(string, null, true);
    }

    public AttributeKey(String string, T t) {
        this(string, t, true);
    }

    public AttributeKey(String string, T t, boolean bl) {
        this.key = string;
        this.defaultValue = t;
        this.isNullValueAllowed = bl;
    }

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T get(Figure figure) {
        Object object = figure.getAttribute(this);
        return (T)(object == null && !this.isNullValueAllowed ? this.defaultValue : object);
    }

    public void set(Figure figure, T t) {
        if (t == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        figure.setAttribute(this, t);
    }

    public void basicSet(Figure figure, T t) {
        if (t == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        figure.basicSetAttribute(this, t);
    }

    public boolean equals(Object object) {
        if (object instanceof AttributeKey) {
            AttributeKey attributeKey = (AttributeKey)object;
            return attributeKey.key.equals(this.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }

    public boolean isNullValueAllowed() {
        return this.isNullValueAllowed;
    }

    public static void main(String[] stringArray) {
        TypeVariable<Class<?>> typeVariable = new AttributeKey("hey").getClass().getTypeParameters()[0];
    }

    public boolean isAssignable(Object object) {
        if (object == null) {
            return this.isNullValueAllowed();
        }
        try {
            Object object2 = object;
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }
}

