/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.undo.CompositeEdit;

public class BezierControlPointHandle
extends AbstractHandle {
    protected int index;
    protected int controlPointIndex;
    private CompositeEdit edit;

    public BezierControlPointHandle(BezierFigure bezierFigure, int n, int n2) {
        super(bezierFigure);
        this.index = n;
        this.controlPointIndex = n2;
    }

    protected BezierFigure getBezierFigure() {
        return (BezierFigure)this.getOwner();
    }

    protected Point getLocation() {
        return this.getBezierFigure().getPointCount() > this.index ? this.view.drawingToView(this.getBezierFigure().getPoint(this.index, this.controlPointIndex)) : new Point(10, 10);
    }

    public void draw(Graphics2D graphics2D) {
        BezierFigure bezierFigure = this.getBezierFigure();
        if (bezierFigure.getPointCount() > this.index) {
            BezierPath.Node node = bezierFigure.getNode(this.index);
            if (node.keepColinear && node.mask == 3 && (this.index > 0 && this.index < bezierFigure.getNodeCount() || bezierFigure.isClosed())) {
                this.drawCircle(graphics2D, Color.white, Color.blue);
            } else {
                this.drawCircle(graphics2D, Color.blue, Color.white);
            }
            graphics2D.setColor(Color.blue);
            graphics2D.draw(new Line2D.Double(this.view.drawingToView(new Point2D.Double(node.x[0], node.y[0])), this.view.drawingToView(new Point2D.Double(node.x[this.controlPointIndex], node.y[this.controlPointIndex]))));
        }
    }

    protected Rectangle basicGetBounds() {
        Rectangle rectangle = new Rectangle(this.getLocation());
        rectangle.grow(this.getHandlesize() / 2, this.getHandlesize() / 2);
        return rectangle;
    }

    public void trackStart(Point point, int n) {
        this.edit = new CompositeEdit("Punkt verschieben");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        Point2D.Double double_ = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(this.getLocation()));
        Point2D.Double double_2 = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point));
    }

    public void trackStep(Point point, Point point2, int n) {
        BezierFigure bezierFigure = this.getBezierFigure();
        Point2D.Double double_ = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point2));
        BezierPath.Node node = bezierFigure.getNode(this.index);
        this.fireAreaInvalidated(node);
        bezierFigure.willChange();
        if (!node.keepColinear) {
            bezierFigure.basicSetPoint(this.index, this.controlPointIndex, double_);
        } else {
            double d = Math.PI + Math.atan2(double_.y - node.y[0], double_.x - node.x[0]);
            int n2 = this.controlPointIndex == 1 ? 2 : 1;
            double d2 = Math.sqrt((node.x[n2] - node.x[0]) * (node.x[n2] - node.x[0]) + (node.y[n2] - node.y[0]) * (node.y[n2] - node.y[0]));
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            Point2D.Double double_2 = new Point2D.Double(d2 * d4 + node.x[0], d2 * d3 + node.y[0]);
            bezierFigure.basicSetPoint(this.index, this.controlPointIndex, double_);
            bezierFigure.basicSetPoint(this.index, n2, double_2);
        }
        bezierFigure.changed();
        this.fireAreaInvalidated(bezierFigure.getNode(this.index));
    }

    private void fireAreaInvalidated(BezierPath.Node node) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(node.x[0], node.y[0], 0.0, 0.0);
        for (int i = 1; i < 3; ++i) {
            double_.add(node.x[i], node.y[i]);
        }
        Rectangle rectangle = this.view.drawingToView(double_);
        rectangle.grow(this.getHandlesize(), this.getHandlesize());
        this.fireAreaInvalidated(rectangle);
    }

    public void trackEnd(Point point, Point point2, int n) {
        BezierFigure bezierFigure = this.getBezierFigure();
        if ((n & 0x180) != 0) {
            bezierFigure.willChange();
            BezierPath.Node node = bezierFigure.getNode(this.index);
            boolean bl = node.keepColinear = !node.keepColinear;
            if (node.keepColinear) {
                Point2D.Double double_ = bezierFigure.getPoint(this.index, this.controlPointIndex);
                double d = Math.PI + Math.atan2(double_.y - node.y[0], double_.x - node.x[0]);
                int n2 = this.controlPointIndex == 1 ? 2 : 1;
                double d2 = Math.sqrt((node.x[n2] - node.x[0]) * (node.x[n2] - node.x[0]) + (node.y[n2] - node.y[0]) * (node.y[n2] - node.y[0]));
                double d3 = Math.sin(d);
                double d4 = Math.cos(d);
                Point2D.Double double_2 = new Point2D.Double(d2 * d4 + node.x[0], d2 * d3 + node.y[0]);
                node.x[n2] = double_2.x;
                node.y[n2] = double_2.y;
            }
            bezierFigure.setNode(this.index, node);
            bezierFigure.changed();
        }
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }

    public boolean isCombinableWith(Handle handle) {
        if (super.isCombinableWith(handle)) {
            BezierControlPointHandle bezierControlPointHandle = (BezierControlPointHandle)handle;
            return bezierControlPointHandle.index == this.index && bezierControlPointHandle.controlPointIndex == this.controlPointIndex && bezierControlPointHandle.getBezierFigure().getNodeCount() == this.getBezierFigure().getNodeCount();
        }
        return false;
    }
}

