/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.BezierNodeEdit;
import org.jhotdraw.draw.BezierNodeHandle;
import org.jhotdraw.draw.BezierScaleHandle;
import org.jhotdraw.draw.BoxHandleKit;
import org.jhotdraw.draw.ChopBezierConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierFigure
extends AttributedFigure {
    public static final AttributeKey<Boolean> CLOSED = new AttributeKey<Boolean>("closed", false);
    protected BezierPath path = new BezierPath();
    private transient BezierPath cappedPath;

    public BezierFigure() {
        this(false);
    }

    public BezierFigure(boolean bl) {
        CLOSED.set(this, bl);
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return new ChopBezierConnector(this);
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return new ChopBezierConnector(this);
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
        if (this.isClosed()) {
            double d = AttributeKeys.getPerpendicularDrawGrowth(this);
            if (d == 0.0) {
                graphics2D.draw(this.path);
            } else {
                GrowStroke growStroke = new GrowStroke((float)d, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
                graphics2D.draw(growStroke.createStrokedShape(this.path));
            }
        } else {
            graphics2D.draw(this.getCappedPath());
        }
        this.drawCaps(graphics2D);
    }

    protected void drawCaps(Graphics2D graphics2D) {
        if (this.getPointCount() > 1) {
            Point2D.Double double_;
            Point2D.Double double_2;
            BezierPath bezierPath;
            if (AttributeKeys.START_DECORATION.get(this) != null) {
                bezierPath = this.getCappedPath();
                double_2 = this.path.get(0, 0);
                double_ = bezierPath.get(0, 0);
                if (double_.equals(double_2)) {
                    double_ = this.path.get(1, 0);
                }
                AttributeKeys.START_DECORATION.get(this).draw(graphics2D, this, double_2, double_);
            }
            if (AttributeKeys.END_DECORATION.get(this) != null) {
                bezierPath = this.getCappedPath();
                double_2 = this.path.get(this.path.size() - 1, 0);
                double_ = bezierPath.get(this.path.size() - 1, 0);
                if (double_.equals(double_2)) {
                    double_ = this.path.get(this.path.size() - 2, 0);
                }
                AttributeKeys.END_DECORATION.get(this).draw(graphics2D, this, double_2, double_);
            }
        }
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
        if (this.isClosed()) {
            double d = AttributeKeys.getPerpendicularFillGrowth(this);
            if (d == 0.0) {
                graphics2D.fill(this.path);
            } else {
                GrowStroke growStroke = new GrowStroke((float)d, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
                graphics2D.fill(growStroke.createStrokedShape(this.path));
            }
        }
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        Point2D.Double double_2;
        Point2D.Double double_3;
        BezierPath bezierPath;
        if (this.isClosed()) {
            double d = AttributeKeys.getPerpendicularHitGrowth(this);
            if (d == 0.0) {
                return this.path.contains(double_);
            }
            GrowStroke growStroke = new GrowStroke((float)d, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
            return growStroke.createStrokedShape(this.path).contains(double_);
        }
        double d = Math.max(2.0, AttributeKeys.getStrokeTotalWidth(this) / 2.0);
        if (this.getCappedPath().outlineContains(double_, d)) {
            return true;
        }
        if (AttributeKeys.START_DECORATION.get(this) != null) {
            bezierPath = this.getCappedPath();
            double_3 = this.path.get(0, 0);
            double_2 = bezierPath.get(0, 0);
            if (Geom.lineContainsPoint(double_3.x, double_3.y, double_2.x, double_2.y, double_.x, double_.y, d)) {
                return true;
            }
        }
        if (AttributeKeys.END_DECORATION.get(this) != null) {
            bezierPath = this.getCappedPath();
            double_3 = this.path.get(this.path.size() - 1, 0);
            double_2 = bezierPath.get(this.path.size() - 1, 0);
            if (Geom.lineContainsPoint(double_3.x, double_3.y, double_2.x, double_2.y, double_.x, double_.y, d)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canConnect() {
        return this.isClosed();
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n) {
            case 0: {
                BoxHandleKit.addBoxHandles(this, linkedList);
                linkedList.add(new BezierScaleHandle(this));
                break;
            }
            case 1: {
                int n2 = this.path.size();
                for (int i = 0; i < n2; ++i) {
                    linkedList.add(new BezierNodeHandle(this, i));
                }
                break;
            }
        }
        return linkedList;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double double_ = this.path.getBounds2DDouble();
        double_.width = Math.max(1.0, double_.width);
        double_.height = Math.max(1.0, double_.height);
        return double_;
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        Rectangle2D.Double double_ = super.getFigureDrawBounds();
        if (this.getNodeCount() > 1) {
            Point2D.Double double_2;
            Point2D.Double double_3;
            if (AttributeKeys.START_DECORATION.get(this) != null) {
                double_3 = this.getPoint(0, 0);
                double_2 = this.getPoint(1, 0);
                double_.add(AttributeKeys.START_DECORATION.get(this).getDrawBounds(this, double_3, double_2));
            }
            if (AttributeKeys.END_DECORATION.get(this) != null) {
                double_3 = this.getPoint(this.getNodeCount() - 1, 0);
                double_2 = this.getPoint(this.getNodeCount() - 2, 0);
                double_.add(AttributeKeys.END_DECORATION.get(this).getDrawBounds(this, double_3, double_2));
            }
        }
        return double_;
    }

    @Override
    protected void validate() {
        super.validate();
        this.path.invalidatePath();
        this.invalidateCappedPath();
    }

    public BezierPath getBezierPath() {
        return (BezierPath)this.path.clone();
    }

    public Point2D.Double getPointOnPath(float f, double d) {
        return this.path.getPointOnPath(f, d);
    }

    public void basicSetBezierPath(BezierPath bezierPath) {
        this.path = bezierPath;
        this.setClosed(bezierPath.isClosed());
    }

    public boolean isClosed() {
        return (Boolean)this.getAttribute(CLOSED);
    }

    public void setClosed(boolean bl) {
        CLOSED.set(this, bl);
    }

    @Override
    public void basicSetAttribute(AttributeKey attributeKey, Object object) {
        if (attributeKey == CLOSED) {
            this.path.setClosed((Boolean)object);
        }
        super.basicSetAttribute(attributeKey, object);
    }

    @Override
    public void basicSetBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.basicSetStartPoint(double_);
        this.basicSetEndPoint(double_2);
        this.invalidate();
    }

    @Override
    public void basicTransform(AffineTransform affineTransform) {
        this.path.transform(affineTransform);
        this.invalidate();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.path.invalidatePath();
        this.invalidateCappedPath();
    }

    protected void invalidateCappedPath() {
        this.cappedPath = null;
    }

    protected BezierPath getCappedPath() {
        if (this.cappedPath == null) {
            this.cappedPath = (BezierPath)this.path.clone();
            if (this.isClosed()) {
                this.cappedPath.setClosed(true);
            } else if (this.cappedPath.size() > 1) {
                double d;
                double d2;
                Point2D.Double double_;
                BezierPath.Node node;
                BezierPath.Node node2;
                if (AttributeKeys.START_DECORATION.get(this) != null) {
                    node2 = (BezierPath.Node)this.cappedPath.get(0);
                    node = (BezierPath.Node)this.cappedPath.get(1);
                    double_ = (node2.getMask() & 2) != 0 ? node2.getControlPoint(2) : ((node.getMask() & 1) != 0 ? node.getControlPoint(1) : node.getControlPoint(0));
                    d2 = AttributeKeys.START_DECORATION.get(this).getDecorationRadius(this);
                    d = Geom.length(node2.getControlPoint(0), double_);
                    this.cappedPath.set(0, 0, Geom.cap(double_, node2.getControlPoint(0), -Math.min(d2, d)));
                }
                if (AttributeKeys.END_DECORATION.get(this) != null) {
                    node2 = (BezierPath.Node)this.cappedPath.get(this.cappedPath.size() - 1);
                    node = (BezierPath.Node)this.cappedPath.get(this.cappedPath.size() - 2);
                    double_ = (node2.getMask() & 1) != 0 ? node2.getControlPoint(1) : ((node.getMask() & 2) != 0 ? node.getControlPoint(2) : node.getControlPoint(0));
                    d2 = AttributeKeys.END_DECORATION.get(this).getDecorationRadius(this);
                    d = Geom.length(node2.getControlPoint(0), double_);
                    this.cappedPath.set(this.cappedPath.size() - 1, 0, Geom.cap(double_, node2.getControlPoint(0), -Math.min(d2, d)));
                }
                this.cappedPath.invalidatePath();
            }
        }
        return this.cappedPath;
    }

    public void layout() {
    }

    public void addNode(BezierPath.Node node) {
        this.addNode(this.getNodeCount(), node);
    }

    public void addNode(final int n, BezierPath.Node node) {
        final BezierPath.Node node2 = new BezierPath.Node(node);
        this.willChange();
        this.basicAddNode(n, node2);
        this.layout();
        this.changed();
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return "Punkt einf\u00fcgen";
            }

            public void undo() throws CannotUndoException {
                super.undo();
                BezierFigure.this.willChange();
                BezierFigure.this.basicRemoveNode(n);
                BezierFigure.this.changed();
            }

            public void redo() throws CannotUndoException {
                super.redo();
                BezierFigure.this.willChange();
                BezierFigure.this.basicAddNode(n, node2);
                BezierFigure.this.changed();
            }
        });
    }

    public void basicAddNode(BezierPath.Node node) {
        this.path.add(node);
        this.invalidate();
    }

    public void basicAddNode(int n, BezierPath.Node node) {
        this.path.add(n, node);
    }

    public void setNode(int n, BezierPath.Node node) {
        this.willChange();
        BezierPath.Node node2 = (BezierPath.Node)this.path.get(n);
        BezierPath.Node node3 = new BezierPath.Node(node);
        this.basicSetNode(n, node3);
        this.changed();
        this.fireUndoableEditHappened(new BezierNodeEdit(this, n, node2, node3));
    }

    public void basicSetNode(int n, BezierPath.Node node) {
        this.path.set(n, node);
    }

    public BezierPath.Node getNode(int n) {
        return (BezierPath.Node)((BezierPath.Node)this.path.get(n)).clone();
    }

    public Point2D.Double getPoint(int n) {
        return ((BezierPath.Node)this.path.get(n)).getControlPoint(0);
    }

    public Point2D.Double getPoint(int n, int n2) {
        return ((BezierPath.Node)this.path.get(n)).getControlPoint(n2);
    }

    public void setPoint(int n, int n2, Point2D.Double double_) {
        this.willChange();
        this.basicSetPoint(n, n2, double_);
        this.changed();
    }

    public void basicSetPoint(int n, Point2D.Double double_) {
        BezierPath.Node node = (BezierPath.Node)this.path.get(n);
        double d = double_.x - node.x[0];
        double d2 = double_.y - node.y[0];
        int n2 = 0;
        while (n2 < node.x.length) {
            int n3 = n2;
            node.x[n3] = node.x[n3] + d;
            int n4 = n2++;
            node.y[n4] = node.y[n4] + d2;
        }
        this.invalidate();
    }

    public void basicSetPoint(int n, int n2, Point2D.Double double_) {
        BezierPath.Node node = new BezierPath.Node((BezierPath.Node)this.path.get(n));
        node.setControlPoint(n2, double_);
        this.basicSetNode(n, node);
    }

    public void basicSetStartPoint(Point2D.Double double_) {
        this.basicSetPoint(0, double_);
    }

    public void basicSetEndPoint(Point2D.Double double_) {
        this.basicSetPoint(this.getPointCount() - 1, double_);
    }

    @Override
    public Point2D.Double getStartPoint() {
        return this.getPoint(0, 0);
    }

    @Override
    public Point2D.Double getEndPoint() {
        return this.getPoint(this.getNodeCount() - 1, 0);
    }

    public int findNode(Point2D.Double double_) {
        BezierPath bezierPath = this.path;
        for (int i = 0; i < bezierPath.size(); ++i) {
            BezierPath.Node node = (BezierPath.Node)bezierPath.get(i);
            if (node.x[0] != double_.x || node.y[0] != double_.y) continue;
            return i;
        }
        return -1;
    }

    public final void removeAllNodes() {
        this.willChange();
        this.basicRemoveAllNodes();
        this.changed();
    }

    public final void removeNode(final int n) {
        final BezierPath.Node node = new BezierPath.Node((BezierPath.Node)this.path.get(n));
        this.willChange();
        this.basicRemoveNode(n);
        this.layout();
        this.changed();
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return "Punkt entfernen";
            }

            public void undo() throws CannotUndoException {
                super.undo();
                BezierFigure.this.willChange();
                BezierFigure.this.basicAddNode(n, node);
                BezierFigure.this.changed();
            }

            public void redo() throws CannotUndoException {
                super.redo();
                BezierFigure.this.basicRemoveNode(n);
                BezierFigure.this.changed();
            }
        });
    }

    public int findSegment(Point2D.Double double_) {
        int n = this.getNodeCount() - 1;
        for (int i = 0; i < n; ++i) {
            Point2D.Double double_2 = this.path.get(i, 0);
            Point2D.Double double_3 = this.path.get(i + 1, 0);
            if (!Geom.lineContainsPoint(double_2.x, double_2.y, double_3.x, double_3.y, double_.x, double_.y, 3.0)) continue;
            return i;
        }
        return -1;
    }

    public boolean basicJoinSegments(Point2D.Double double_) {
        int n = this.findSegment(double_);
        if (n != -1 && n > 1) {
            this.removeNode(n);
            return true;
        }
        return false;
    }

    public int basicSplitSegment(Point2D.Double double_) {
        int n = this.findSegment(double_);
        if (n != -1) {
            this.addNode(n + 1, new BezierPath.Node(double_));
        }
        return n + 1;
    }

    protected void basicRemoveNode(int n) {
        this.path.remove(n);
    }

    protected void basicRemoveAllNodes() {
        this.path.clear();
    }

    public int getNodeCount() {
        return this.path.size();
    }

    public int getPointCount() {
        return this.path.size();
    }

    @Override
    public BezierFigure clone() {
        BezierFigure bezierFigure = (BezierFigure)super.clone();
        bezierFigure.path = (BezierPath)this.path.clone();
        bezierFigure.invalidate();
        return bezierFigure;
    }

    @Override
    public void restoreTo(Object object) {
        this.path.setTo((BezierPath)object);
    }

    @Override
    public Object getRestoreData() {
        return this.path.clone();
    }

    public Point2D.Double chop(Point2D.Double double_) {
        if (this.isClosed()) {
            double d = AttributeKeys.getPerpendicularHitGrowth(this);
            if (d == 0.0) {
                return this.path.chop(double_);
            }
            GrowStroke growStroke = new GrowStroke((float)d, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
            return Geom.chop(growStroke.createStrokedShape(this.path), double_);
        }
        return this.path.chop(double_);
    }

    public Point2D.Double getCenter() {
        return this.path.getCenter();
    }

    public Point2D.Double getOutermostPoint() {
        return ((BezierPath.Node)this.path.get(this.path.indexOfOutermostNode())).getControlPoint(0);
    }

    public int basicJoinSegments(Point2D.Double double_, float f) {
        return this.path.joinSegments(double_, f);
    }

    public int basicSplitSegment(Point2D.Double double_, float f) {
        return this.path.splitSegment(double_, f);
    }

    @Override
    public boolean handleMouseClick(Point2D.Double double_, MouseEvent mouseEvent, DrawingView drawingView) {
        if (mouseEvent.getClickCount() == 2 && drawingView.getHandleDetailLevel() == 1) {
            this.willChange();
            final int n = this.basicSplitSegment(double_, (float)(5.0 / drawingView.getScaleFactor()));
            if (n != -1) {
                final BezierPath.Node node = this.getNode(n);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    public void redo() throws CannotRedoException {
                        super.redo();
                        BezierFigure.this.willChange();
                        BezierFigure.this.basicAddNode(n, node);
                        BezierFigure.this.changed();
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        BezierFigure.this.willChange();
                        BezierFigure.this.basicRemoveNode(n);
                        BezierFigure.this.changed();
                    }
                });
                this.changed();
                return true;
            }
        }
        return false;
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        this.writePoints(dOMOutput);
        this.writeAttributes(dOMOutput);
    }

    protected void writePoints(DOMOutput dOMOutput) throws IOException {
        dOMOutput.openElement("points");
        if (this.isClosed()) {
            dOMOutput.addAttribute("closed", true);
        }
        int n = this.getNodeCount();
        for (int i = 0; i < n; ++i) {
            BezierPath.Node node = this.getNode(i);
            dOMOutput.openElement("p");
            if (node.mask != 0) {
                dOMOutput.addAttribute("mask", node.mask);
            }
            if (!node.keepColinear) {
                dOMOutput.addAttribute("colinear", false);
            }
            dOMOutput.addAttribute("x", node.x[0]);
            dOMOutput.addAttribute("y", node.y[0]);
            if (node.x[1] != node.x[0] || node.y[1] != node.y[0]) {
                dOMOutput.addAttribute("c1x", node.x[1]);
                dOMOutput.addAttribute("c1y", node.y[1]);
            }
            if (node.x[2] != node.x[0] || node.y[2] != node.y[0]) {
                dOMOutput.addAttribute("c2x", node.x[2]);
                dOMOutput.addAttribute("c2y", node.y[2]);
            }
            dOMOutput.closeElement();
        }
        dOMOutput.closeElement();
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        this.readPoints(dOMInput);
        this.readAttributes(dOMInput);
    }

    protected void readPoints(DOMInput dOMInput) throws IOException {
        this.path.clear();
        dOMInput.openElement("points");
        this.setClosed(dOMInput.getAttribute("closed", false));
        int n = dOMInput.getElementCount("p");
        for (int i = 0; i < n; ++i) {
            dOMInput.openElement("p", i);
            BezierPath.Node node = new BezierPath.Node(dOMInput.getAttribute("mask", 0), dOMInput.getAttribute("x", 0.0), dOMInput.getAttribute("y", 0.0), dOMInput.getAttribute("c1x", dOMInput.getAttribute("x", 0.0)), dOMInput.getAttribute("c1y", dOMInput.getAttribute("y", 0.0)), dOMInput.getAttribute("c2x", dOMInput.getAttribute("x", 0.0)), dOMInput.getAttribute("c2y", dOMInput.getAttribute("y", 0.0)));
            node.keepColinear = dOMInput.getAttribute("colinear", true);
            this.path.add(node);
            this.path.invalidatePath();
            dOMInput.closeElement();
        }
        dOMInput.closeElement();
    }
}

