/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.BezierControlPointHandle;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeEdit;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierNodeHandle
extends AbstractHandle {
    protected int index;
    private CompositeEdit edit;
    private BezierPath.Node oldNode;

    public BezierNodeHandle(BezierFigure bezierFigure, int n) {
        super(bezierFigure);
        this.index = n;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        BezierFigure bezierFigure = this.getBezierFigure();
        if (bezierFigure.getPointCount() > this.index) {
            BezierPath.Node node = bezierFigure.getNode(this.index);
            if (node.mask == 0) {
                this.drawRectangle(graphics2D, Color.black, Color.white);
            } else if (node.mask == 1 || node.mask == 2 || !bezierFigure.isClosed() && node.mask == 3 && this.index == 0 || this.index == bezierFigure.getNodeCount() - 1) {
                this.drawDiamond(graphics2D, Color.black, Color.white);
            } else {
                this.drawCircle(graphics2D, Color.black, Color.white);
            }
        }
    }

    protected BezierFigure getBezierFigure() {
        return (BezierFigure)this.getOwner();
    }

    protected Point getLocation() {
        return this.getBezierFigure().getPointCount() > this.index ? this.view.drawingToView(this.getBezierFigure().getPoint(this.index, 0)) : new Point(10, 10);
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle rectangle = new Rectangle(this.getLocation());
        rectangle.grow(this.getHandlesize() / 2, this.getHandlesize() / 2);
        return rectangle;
    }

    @Override
    public void trackStart(Point point, int n) {
        BezierFigure bezierFigure = this.getBezierFigure();
        this.edit = new CompositeEdit("Punkt verschieben");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        Point2D.Double double_ = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(this.getLocation()));
        Point2D.Double double_2 = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point));
        this.oldNode = bezierFigure.getNode(this.index);
        this.fireHandleRequestSecondaryHandles();
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
        BezierFigure bezierFigure = this.getBezierFigure();
        bezierFigure.willChange();
        Point2D.Double double_ = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point2));
        BezierPath.Node node = bezierFigure.getNode(this.index);
        this.fireAreaInvalidated(node);
        node.moveTo(double_);
        this.fireAreaInvalidated(node);
        bezierFigure.basicSetNode(this.index, node);
        bezierFigure.changed();
    }

    private void fireAreaInvalidated(BezierPath.Node node) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(node.x[0], node.y[0], 0.0, 0.0);
        for (int i = 1; i < 3; ++i) {
            double_.add(node.x[i], node.y[i]);
        }
        Rectangle rectangle = this.view.drawingToView(double_);
        rectangle.grow(this.getHandlesize(), this.getHandlesize());
        this.fireAreaInvalidated(rectangle);
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
        BezierFigure bezierFigure = this.getBezierFigure();
        if ((n & 0x180) != 0 && (n & 0x800) == 0) {
            bezierFigure.willChange();
            BezierPath.Node node = bezierFigure.getNode(this.index);
            node.mask = this.index > 0 && this.index < bezierFigure.getNodeCount() || bezierFigure.isClosed() ? (node.mask + 3) % 4 : (this.index == 0 ? ((node.mask & 2) == 0 ? 2 : 0) : ((node.mask & 1) == 0 ? 1 : 0));
            bezierFigure.basicSetNode(this.index, node);
            bezierFigure.changed();
            this.fireHandleRequestSecondaryHandles();
        }
        this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(bezierFigure, this.index, this.oldNode, bezierFigure.getNode(this.index)));
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }

    @Override
    public boolean isCombinableWith(Handle handle) {
        return false;
    }

    @Override
    public void trackDoubleClick(Point point, int n) {
        BezierFigure bezierFigure = this.getBezierFigure();
        if (bezierFigure.getNodeCount() > 2 && (n & 0x380) == 0) {
            Rectangle rectangle = this.getDrawBounds();
            bezierFigure.willChange();
            bezierFigure.basicRemoveNode(this.index);
            bezierFigure.changed();
            this.fireHandleRequestRemove(rectangle);
        }
    }

    @Override
    public Collection<Handle> createSecondaryHandles() {
        int n;
        BezierFigure bezierFigure = this.getBezierFigure();
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        BezierPath.Node node = bezierFigure.getNode(this.index);
        if ((node.mask & 1) != 0 && (this.index != 0 || bezierFigure.isClosed())) {
            linkedList.add(new BezierControlPointHandle(bezierFigure, this.index, 1));
        }
        if ((node.mask & 2) != 0 && (this.index < bezierFigure.getNodeCount() - 1 || bezierFigure.isClosed())) {
            linkedList.add(new BezierControlPointHandle(bezierFigure, this.index, 2));
        }
        if (this.index > 0 || bezierFigure.isClosed()) {
            n = this.index == 0 ? bezierFigure.getNodeCount() - 1 : this.index - 1;
            node = bezierFigure.getNode(n);
            if ((node.mask & 2) != 0) {
                linkedList.add(new BezierControlPointHandle(bezierFigure, n, 2));
            }
        }
        if (this.index < bezierFigure.getNodeCount() - 2 || bezierFigure.isClosed()) {
            n = this.index == bezierFigure.getNodeCount() - 1 ? 0 : this.index + 1;
            node = bezierFigure.getNode(n);
            if ((node.mask & 1) != 0) {
                linkedList.add(new BezierControlPointHandle(bezierFigure, n, 1));
            }
        }
        return linkedList;
    }
}

