/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreationTool
extends AbstractTool {
    private Map<AttributeKey, Object> attributes;
    private String name;
    private Dimension minimalSizeTreshold = new Dimension(10, 10);
    private Dimension minimalSize = new Dimension(40, 40);
    private Figure prototype;
    protected Figure createdFigure;
    protected CompositeEdit creationEdit;

    public CreationTool(String string) {
        this(string, null, null);
    }

    public CreationTool(String string, Map<AttributeKey, Object> map) {
        this(string, map, null);
    }

    public CreationTool(String string, Map<AttributeKey, Object> map, String string2) {
        try {
            this.prototype = (Figure)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Unable to create Figure from " + string);
            internalError.initCause(exception);
            throw internalError;
        }
        this.attributes = map;
        this.name = string2;
    }

    public CreationTool(Figure figure) {
        this(figure, null, null);
    }

    public CreationTool(Figure figure, Map<AttributeKey, Object> map) {
        this(figure, map, null);
    }

    public CreationTool(Figure figure, Map<AttributeKey, Object> map, String string) {
        this.prototype = figure;
        this.attributes = map;
        this.name = string;
    }

    public Figure getPrototype() {
        return this.prototype;
    }

    @Override
    public void activate(DrawingEditor drawingEditor) {
        super.activate(drawingEditor);
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        super.deactivate(drawingEditor);
        if (this.getView() != null) {
            this.getView().setCursor(Cursor.getDefaultCursor());
        }
        if (this.createdFigure != null) {
            if (this.createdFigure instanceof CompositeFigure) {
                ((CompositeFigure)this.createdFigure).layout();
            }
            this.createdFigure = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.getView().clearSelection();
        this.creationEdit = new CompositeEdit("Figur erstellen");
        this.getDrawing().fireUndoableEditHappened(this.creationEdit);
        this.createdFigure = this.createFigure();
        Point2D.Double double_ = this.constrainPoint(this.viewToDrawing(this.anchor));
        this.anchor.x = mouseEvent.getX();
        this.anchor.y = mouseEvent.getY();
        this.createdFigure.willChange();
        this.createdFigure.basicSetBounds(double_, double_);
        this.createdFigure.changed();
        this.getDrawing().add(this.createdFigure);
    }

    protected Figure createFigure() {
        Figure figure = (Figure)this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(figure);
        if (this.attributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
                figure.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return figure;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected Figure getAddedFigure() {
        return this.createdFigure;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.createdFigure != null) {
            Point2D.Double double_ = this.constrainPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            this.createdFigure.willChange();
            this.createdFigure.basicSetBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), double_);
            this.createdFigure.changed();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.createdFigure != null) {
            Rectangle2D.Double double_ = this.createdFigure.getBounds();
            if (double_.width == 0.0 && double_.height == 0.0) {
                this.getDrawing().remove(this.createdFigure);
            } else {
                if (Math.abs(this.anchor.x - mouseEvent.getX()) < this.minimalSizeTreshold.width && Math.abs(this.anchor.y - mouseEvent.getY()) < this.minimalSizeTreshold.height) {
                    this.createdFigure.basicSetBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(double_.width, (double)this.minimalSize.width), this.anchor.y + (int)Math.max(double_.height, (double)this.minimalSize.height))));
                }
                this.getView().addToSelection(this.createdFigure);
            }
            if (this.createdFigure instanceof CompositeFigure) {
                ((CompositeFigure)this.createdFigure).layout();
            }
            this.createdFigure = null;
            this.getDrawing().fireUndoableEditHappened(this.creationEdit);
            this.fireToolDone();
        }
    }
}

