/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractDrawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureLayerComparator;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.util.ReversedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDrawing
extends AbstractDrawing
implements FigureListener,
UndoableEditListener {
    private ArrayList<Figure> figures = new ArrayList();
    private boolean needsSorting = false;

    @Override
    protected int indexOf(Figure figure) {
        return this.figures.indexOf(figure);
    }

    @Override
    public void basicAdd(int n, Figure figure) {
        this.figures.add(n, figure);
        figure.addFigureListener(this);
        figure.addUndoableEditListener(this);
        this.invalidateSortOrder();
    }

    @Override
    public void basicRemove(Figure figure) {
        this.figures.remove(figure);
        figure.removeFigureListener(this);
        figure.removeUndoableEditListener(this);
        this.invalidateSortOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D graphics2D) {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureSorted();
            ArrayList<Figure> arrayList = new ArrayList<Figure>(this.figures.size());
            Rectangle rectangle = graphics2D.getClipBounds();
            for (Figure figure : this.figures) {
                if (!figure.getDrawBounds().intersects(rectangle)) continue;
                arrayList.add(figure);
            }
            this.draw(graphics2D, arrayList);
        }
    }

    public void draw(Graphics2D graphics2D, Collection<Figure> collection) {
        for (Figure figure : collection) {
            if (!figure.isVisible()) continue;
            figure.draw(graphics2D);
        }
    }

    @Override
    public Collection<Figure> sort(Collection<Figure> collection) {
        HashSet<Figure> hashSet = new HashSet<Figure>();
        hashSet.addAll(collection);
        ArrayList<Figure> arrayList = new ArrayList<Figure>(collection.size());
        for (Figure figure : this.figures) {
            if (!hashSet.contains(figure)) continue;
            arrayList.add(figure);
            hashSet.remove(figure);
        }
        for (Figure figure : collection) {
            if (!hashSet.contains(figure)) continue;
            arrayList.add(figure);
            hashSet.remove(figure);
        }
        return arrayList;
    }

    @Override
    public void figureAreaInvalidated(FigureEvent figureEvent) {
        this.fireAreaInvalidated(figureEvent.getInvalidatedArea());
    }

    @Override
    public void figureChanged(FigureEvent figureEvent) {
        this.invalidateSortOrder();
        this.fireAreaInvalidated(figureEvent.getInvalidatedArea());
    }

    @Override
    public void figureAdded(FigureEvent figureEvent) {
    }

    @Override
    public void figureRemoved(FigureEvent figureEvent) {
    }

    @Override
    public void figureRequestRemove(FigureEvent figureEvent) {
        this.remove(figureEvent.getFigure());
    }

    @Override
    public Figure findFigure(Point2D.Double double_) {
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (!figure.isVisible() || !figure.contains(double_)) continue;
            return figure;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double double_, Figure figure) {
        for (Figure figure2 : this.getFiguresFrontToBack()) {
            if (figure2 == figure || !figure2.isVisible() || !figure2.contains(double_)) continue;
            return figure2;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double double_, Collection<Figure> collection) {
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (collection.contains(figure) || !figure.isVisible() || !figure.contains(double_)) continue;
            return figure;
        }
        return null;
    }

    @Override
    public Collection<Figure> findFigures(Rectangle2D.Double double_) {
        ArrayList<Figure> arrayList = new ArrayList<Figure>();
        for (Figure figure : this.figures) {
            if (!figure.isVisible() || !figure.getBounds().intersects(double_)) continue;
            arrayList.add(figure);
        }
        return arrayList;
    }

    @Override
    public Collection<Figure> findFiguresWithin(Rectangle2D.Double double_) {
        ArrayList<Figure> arrayList = new ArrayList<Figure>();
        for (Figure figure : this.figures) {
            if (!figure.isVisible() || !double_.contains(figure.getBounds())) continue;
            arrayList.add(figure);
        }
        return arrayList;
    }

    @Override
    public Collection<Figure> getFigures() {
        return Collections.unmodifiableCollection(this.figures);
    }

    @Override
    public Figure findFigureInside(Point2D.Double double_) {
        Figure figure = this.findFigure(double_);
        return figure == null ? null : figure.findFigureInside(double_);
    }

    @Override
    public List<Figure> getFiguresFrontToBack() {
        this.ensureSorted();
        return new ReversedList<Figure>(this.figures);
    }

    @Override
    public void bringToFront(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(figure);
            this.invalidateSortOrder();
            this.fireAreaInvalidated(figure.getDrawBounds());
        }
    }

    @Override
    public void sendToBack(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(0, figure);
            this.invalidateSortOrder();
            this.fireAreaInvalidated(figure.getDrawBounds());
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.fireUndoableEditHappened(undoableEditEvent.getEdit());
    }

    @Override
    public void figureAttributeChanged(FigureEvent figureEvent) {
    }

    @Override
    public boolean contains(Figure figure) {
        return this.figures.contains(figure);
    }

    private void invalidateSortOrder() {
        this.needsSorting = true;
    }

    private void ensureSorted() {
        if (this.needsSorting) {
            Collections.sort(this.figures, FigureLayerComparator.INSTANCE);
            this.needsSorting = false;
        }
    }
}

