/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jhotdraw.app.EditableComponent;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingEvent;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleEvent;
import org.jhotdraw.draw.HandleListener;
import org.jhotdraw.draw.Options;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.gui.datatransfer.CompositeTransferable;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.NanoXMLLiteDOMInput;
import org.jhotdraw.xml.NanoXMLLiteDOMOutput;
import org.jhotdraw.xml.XMLTransferable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDrawingView
extends JComponent
implements DrawingView,
DrawingListener,
HandleListener,
EditableComponent {
    private Drawing drawing;
    private Set<Figure> dirtyFigures = new HashSet<Figure>();
    private Set<Figure> selectedFigures = new HashSet<Figure>();
    private int rainbow = 0;
    private LinkedList<Handle> selectionHandles = new LinkedList();
    private Handle secondaryHandleOwner;
    private LinkedList<Handle> secondaryHandles = new LinkedList();
    private boolean handlesAreValid = true;
    private Dimension preferredSize;
    private double scaleFactor = 1.0;
    private Point2D.Double translate = new Point2D.Double(0.0, 0.0);
    private int detailLevel;
    private DOMFactory domFactory;
    private DrawingEditor editor;
    private Constrainer constrainer = new GridConstrainer(1.0, 1.0);
    private JLabel emptyDrawingLabel;
    private ButtonGroup buttonGroup1;

    public DefaultDrawingView() {
        this.initComponents();
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                DefaultDrawingView.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                DefaultDrawingView.this.repaint();
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.setLayout(null);
        this.setBackground(new Color(255, 255, 255));
    }

    @Override
    public Drawing getDrawing() {
        return this.drawing;
    }

    @Override
    public Set getTools() {
        return null;
    }

    public void setEmptyDrawingMessage(String string) {
        String string2;
        String string3 = string2 = this.emptyDrawingLabel == null ? null : this.emptyDrawingLabel.getText();
        if (string == null) {
            this.emptyDrawingLabel = null;
        } else {
            this.emptyDrawingLabel = new JLabel(string);
            this.emptyDrawingLabel.setHorizontalAlignment(0);
        }
        this.firePropertyChange("emptyDrawingMessage", string2, string);
        this.repaint();
    }

    public String getEmptyDrawingMessage() {
        return this.emptyDrawingLabel == null ? null : this.emptyDrawingLabel.getText();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, Options.isFractionalMetrics() ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Options.isTextAntialiased() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.drawBackground(graphics2D);
        this.drawGrid(graphics2D);
        this.drawDrawing(graphics2D);
        this.drawHandles(graphics2D);
        this.drawTool(graphics2D);
    }

    protected void drawBackground(Graphics2D graphics2D) {
        int n = (int)(-this.translate.x * this.scaleFactor);
        int n2 = (int)(-this.translate.y * this.scaleFactor);
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(n, n2, n3 - n, n4 - n2);
        if (n2 > 0) {
            graphics2D.setColor(new Color(0xF0F0F0));
            graphics2D.fillRect(0, 0, n3, n2);
        }
        if (n > 0) {
            graphics2D.setColor(new Color(0xF0F0F0));
            graphics2D.fillRect(0, 0, n, n4);
        }
    }

    protected void drawGrid(Graphics2D graphics2D) {
        this.constrainer.draw(graphics2D, this);
    }

    protected void drawDrawing(Graphics2D graphics2D) {
        if (this.drawing != null) {
            if (this.drawing.getFigureCount() == 0 && this.emptyDrawingLabel != null) {
                this.emptyDrawingLabel.setBounds(0, 0, this.getWidth(), this.getHeight());
                this.emptyDrawingLabel.paint(graphics2D);
            } else {
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
                AffineTransform affineTransform = graphics2D2.getTransform();
                affineTransform.translate(-this.translate.x * this.scaleFactor, -this.translate.y * this.scaleFactor);
                affineTransform.scale(this.scaleFactor, this.scaleFactor);
                graphics2D2.setTransform(affineTransform);
                this.drawing.setFontRenderContext(graphics2D2.getFontRenderContext());
                this.drawing.draw(graphics2D2);
                graphics2D2.dispose();
            }
        }
    }

    protected void drawHandles(Graphics2D graphics2D) {
        if (this.editor != null && this.editor.getFocusedView() == this) {
            this.validateHandles();
            for (Handle handle : this.getSelectionHandles()) {
                handle.draw(graphics2D);
            }
            for (Handle handle : this.getSecondaryHandles()) {
                handle.draw(graphics2D);
            }
        }
    }

    protected void drawTool(Graphics2D graphics2D) {
        if (this.editor != null && this.editor.getView() == this && this.editor.getTool() != null) {
            this.editor.getTool().draw(graphics2D);
        }
    }

    @Override
    public void setDrawing(Drawing drawing) {
        if (this.drawing != null) {
            this.drawing.removeDrawingListener(this);
            this.clearSelection();
        }
        this.drawing = drawing;
        if (this.drawing != null) {
            this.drawing.addDrawingListener(this);
        }
        this.invalidateDimension();
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.repaint();
    }

    protected void repaint(Rectangle2D.Double double_) {
        Rectangle rectangle = this.drawingToView(double_);
        rectangle.grow(1, 1);
        this.repaint(rectangle);
    }

    @Override
    public void areaInvalidated(DrawingEvent drawingEvent) {
        this.repaint(drawingEvent.getInvalidatedArea());
        this.invalidateDimension();
    }

    @Override
    public void areaInvalidated(HandleEvent handleEvent) {
        this.repaint(handleEvent.getInvalidatedArea());
        this.invalidateDimension();
    }

    @Override
    public void figureAdded(DrawingEvent drawingEvent) {
        if (drawingEvent.getDrawing().getFigureCount() == 1) {
            this.repaint();
        } else {
            this.repaint(drawingEvent.getInvalidatedArea());
        }
        this.invalidateDimension();
    }

    @Override
    public void figureRemoved(DrawingEvent drawingEvent) {
        if (drawingEvent.getDrawing().getFigureCount() == 0) {
            this.repaint();
        } else {
            this.repaint(drawingEvent.getInvalidatedArea());
        }
        this.removeFromSelection(drawingEvent.getFigure());
        this.invalidateDimension();
    }

    @Override
    public void invalidate() {
        this.invalidateDimension();
        super.invalidate();
    }

    @Override
    public void addToSelection(Figure figure) {
        this.selectedFigures.add(figure);
        this.invalidateHandles();
        this.fireSelectionChanged();
        this.repaint();
    }

    @Override
    public void addToSelection(Collection<Figure> collection) {
        this.selectedFigures.addAll(collection);
        this.invalidateHandles();
        this.fireSelectionChanged();
        this.repaint();
    }

    @Override
    public void removeFromSelection(Figure figure) {
        if (this.selectedFigures.remove(figure)) {
            this.invalidateHandles();
            this.fireSelectionChanged();
        }
        this.repaint();
    }

    @Override
    public void toggleSelection(Figure figure) {
        if (this.selectedFigures.contains(figure)) {
            this.selectedFigures.remove(figure);
        } else {
            this.selectedFigures.add(figure);
        }
        this.fireSelectionChanged();
        this.invalidateHandles();
        this.repaint();
    }

    @Override
    public void selectAll() {
        this.selectedFigures.clear();
        this.selectedFigures.addAll(this.drawing.getFigures());
        this.invalidateHandles();
        this.fireSelectionChanged();
        this.repaint();
    }

    @Override
    public void clearSelection() {
        if (this.getSelectionCount() > 0) {
            this.selectedFigures.clear();
            this.invalidateHandles();
            this.fireSelectionChanged();
        }
        this.repaint();
    }

    @Override
    public boolean isFigureSelected(Figure figure) {
        return this.selectedFigures.contains(figure);
    }

    @Override
    public Collection<Figure> getSelectedFigures() {
        return Collections.unmodifiableSet(this.selectedFigures);
    }

    @Override
    public int getSelectionCount() {
        return this.selectedFigures.size();
    }

    private List<Handle> getSelectionHandles() {
        this.validateHandles();
        return Collections.unmodifiableList(this.selectionHandles);
    }

    private List<Handle> getSecondaryHandles() {
        this.validateHandles();
        return Collections.unmodifiableList(this.secondaryHandles);
    }

    private void invalidateHandles() {
        if (this.handlesAreValid) {
            this.handlesAreValid = false;
            Rectangle rectangle = null;
            for (Handle handle : this.selectionHandles) {
                handle.removeHandleListener(this);
                if (rectangle == null) {
                    rectangle = handle.getDrawBounds();
                } else {
                    rectangle.add(handle.getDrawBounds());
                }
                handle.dispose();
            }
            this.selectionHandles.clear();
            this.secondaryHandles.clear();
            switch (this.selectedFigures.size()) {
                case 0: {
                    if (rectangle == null) break;
                    this.repaint(rectangle);
                    break;
                }
                case 1: {
                    if (rectangle == null) break;
                    this.repaint(rectangle);
                    break;
                }
                default: {
                    this.repaint();
                }
            }
        }
    }

    private void validateHandles() {
        if (!this.handlesAreValid) {
            this.handlesAreValid = true;
            Rectangle rectangle = null;
            int n = this.detailLevel;
            do {
                for (Figure figure : this.getSelectedFigures()) {
                    for (Handle handle : figure.createHandles(n)) {
                        handle.setView(this);
                        this.selectionHandles.add(handle);
                        handle.addHandleListener(this);
                        if (rectangle == null) {
                            rectangle = handle.getBounds();
                            continue;
                        }
                        rectangle.add(handle.getBounds());
                    }
                }
            } while (n-- > 0 && this.selectionHandles.size() == 0);
            this.detailLevel = n + 1;
            if (rectangle != null) {
                this.repaint(rectangle);
            }
        }
    }

    @Override
    public Handle findHandle(Point point) {
        this.validateHandles();
        for (Handle handle : new ReversedList<Handle>(this.getSecondaryHandles())) {
            if (!handle.contains(point)) continue;
            return handle;
        }
        for (Handle handle : new ReversedList<Handle>(this.getSelectionHandles())) {
            if (!handle.contains(point)) continue;
            return handle;
        }
        return null;
    }

    @Override
    public Collection<Handle> getCompatibleHandles(Handle handle) {
        this.validateHandles();
        HashSet<Figure> hashSet = new HashSet<Figure>();
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        hashSet.add(handle.getOwner());
        linkedList.add(handle);
        for (Handle handle2 : this.getSelectionHandles()) {
            if (hashSet.contains(handle2.getOwner()) || !handle2.isCombinableWith(handle)) continue;
            hashSet.add(handle2.getOwner());
            linkedList.add(handle2);
        }
        return linkedList;
    }

    @Override
    public Figure findFigure(Point point) {
        return this.getDrawing().findFigure(this.viewToDrawing(point));
    }

    @Override
    public Collection<Figure> findFigures(Rectangle rectangle) {
        return this.getDrawing().findFigures(this.viewToDrawing(rectangle));
    }

    @Override
    public Collection<Figure> findFiguresWithin(Rectangle rectangle) {
        return this.getDrawing().findFiguresWithin(this.viewToDrawing(rectangle));
    }

    @Override
    public void addFigureSelectionListener(FigureSelectionListener figureSelectionListener) {
        this.listenerList.add(FigureSelectionListener.class, figureSelectionListener);
    }

    @Override
    public void removeFigureSelectionListener(FigureSelectionListener figureSelectionListener) {
        this.listenerList.remove(FigureSelectionListener.class, figureSelectionListener);
    }

    protected void fireSelectionChanged() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureSelectionEvent figureSelectionEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureSelectionListener.class) continue;
                if (figureSelectionEvent == null) {
                    figureSelectionEvent = new FigureSelectionEvent(this);
                }
                ((FigureSelectionListener)objectArray[i + 1]).selectionChanged(figureSelectionEvent);
            }
        }
    }

    @Override
    public void handleRequestRemove(HandleEvent handleEvent) {
        this.selectionHandles.remove(handleEvent.getHandle());
        handleEvent.getHandle().dispose();
        this.invalidateHandles();
        this.repaint(handleEvent.getInvalidatedArea());
    }

    protected void invalidateDimension() {
        this.preferredSize = null;
    }

    @Override
    public Constrainer getConstrainer() {
        return this.constrainer;
    }

    @Override
    public void setConstrainer(Constrainer constrainer) {
        Constrainer constrainer2 = this.constrainer;
        this.constrainer = constrainer;
        this.repaint();
        this.firePropertyChange("constrainer", constrainer2, constrainer);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            Dimension2DDouble dimension2DDouble = new Dimension2DDouble();
            if (this.drawing != null) {
                this.translate.x = 0.0;
                this.translate.y = 0.0;
                for (Figure figure : this.drawing.getFigures()) {
                    Rectangle2D.Double double_ = figure.getDrawBounds();
                    dimension2DDouble.width = Math.max(dimension2DDouble.width, double_.x + double_.width);
                    dimension2DDouble.height = Math.max(dimension2DDouble.height, double_.y + double_.height);
                    this.translate.x = Math.min(this.translate.x, double_.x);
                    this.translate.y = Math.min(this.translate.y, double_.y);
                }
            }
            this.preferredSize = new Dimension((int)((dimension2DDouble.width + 10.0 - this.translate.x) * this.scaleFactor), (int)((dimension2DDouble.height + 10.0 - this.translate.y) * this.scaleFactor));
            this.fireViewTransformChanged();
            this.repaint();
        }
        return this.preferredSize;
    }

    @Override
    public Point drawingToView(Point2D.Double double_) {
        return new Point((int)((double_.x - this.translate.x) * this.scaleFactor), (int)((double_.y - this.translate.y) * this.scaleFactor));
    }

    @Override
    public Point2D.Double viewToDrawing(Point point) {
        return new Point2D.Double((double)point.x / this.scaleFactor + this.translate.x, (double)point.y / this.scaleFactor + this.translate.y);
    }

    @Override
    public Rectangle drawingToView(Rectangle2D.Double double_) {
        return new Rectangle((int)((double_.x - this.translate.x) * this.scaleFactor), (int)((double_.y - this.translate.y) * this.scaleFactor), (int)(double_.width * this.scaleFactor), (int)(double_.height * this.scaleFactor));
    }

    @Override
    public Rectangle2D.Double viewToDrawing(Rectangle rectangle) {
        return new Rectangle2D.Double((double)rectangle.x / this.scaleFactor + this.translate.x, (double)rectangle.y / this.scaleFactor + this.translate.y, (double)rectangle.width / this.scaleFactor, (double)rectangle.height / this.scaleFactor);
    }

    @Override
    public Container getContainer() {
        return this;
    }

    @Override
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setScaleFactor(double d) {
        double d2 = this.scaleFactor;
        this.scaleFactor = d;
        this.fireViewTransformChanged();
        this.firePropertyChange("scaleFactor", d2, d);
        this.invalidateDimension();
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.repaint();
    }

    protected void fireViewTransformChanged() {
        for (Handle handle : this.selectionHandles) {
            handle.viewTransformChanged();
        }
        for (Handle handle : this.secondaryHandles) {
            handle.viewTransformChanged();
        }
    }

    @Override
    public void setHandleDetailLevel(int n) {
        this.detailLevel = n;
        this.invalidateHandles();
        this.repaint();
    }

    @Override
    public int getHandleDetailLevel() {
        return this.detailLevel;
    }

    @Override
    public void handleRequestSecondaryHandles(HandleEvent handleEvent) {
        this.secondaryHandleOwner = handleEvent.getHandle();
        this.secondaryHandles.clear();
        this.secondaryHandles.addAll(this.secondaryHandleOwner.createSecondaryHandles());
        for (Handle handle : this.secondaryHandles) {
            handle.setView(this);
            handle.addHandleListener(this);
        }
        this.repaint();
    }

    @Override
    public AffineTransform getDrawingToViewTransform() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(this.scaleFactor, this.scaleFactor);
        affineTransform.translate(-this.translate.x, -this.translate.y);
        return affineTransform;
    }

    public void setDOMFactory(DOMFactory dOMFactory) {
        DOMFactory dOMFactory2 = this.domFactory;
        this.domFactory = dOMFactory;
        this.firePropertyChange("DOMFactory", dOMFactory2, dOMFactory);
    }

    public DOMFactory getDOMFactory() {
        return this.domFactory;
    }

    @Override
    public void copy() {
        if (this.domFactory == null) {
            this.getToolkit().beep();
            return;
        }
        HashSet<Figure> hashSet = new HashSet<Figure>(this.getSelectedFigures());
        if (hashSet.size() == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            NanoXMLLiteDOMOutput nanoXMLLiteDOMOutput = new NanoXMLLiteDOMOutput(this.domFactory);
            nanoXMLLiteDOMOutput.openElement("DrawingClip");
            for (Figure object2 : this.getDrawing().getFigures()) {
                if (!hashSet.contains(object2)) continue;
                nanoXMLLiteDOMOutput.writeObject(object2);
            }
            nanoXMLLiteDOMOutput.closeElement();
            nanoXMLLiteDOMOutput.save(byteArrayOutputStream);
            Object object3 = byteArrayOutputStream.toByteArray();
            CompositeTransferable compositeTransferable = new CompositeTransferable();
            compositeTransferable.add(new XMLTransferable((byte[])object3, "application/x-drawing-clip", "DrawingClip"));
            compositeTransferable.add(new XMLTransferable((byte[])object3, "text/xml", "DrawingClip"));
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(compositeTransferable, compositeTransferable);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.getToolkit().beep();
        }
    }

    @Override
    public void cut() {
        if (this.domFactory == null) {
            this.getToolkit().beep();
            return;
        }
        this.copy();
        this.delete();
    }

    @Override
    public void delete() {
        ArrayList<Figure> arrayList = new ArrayList<Figure>(this.getSelectedFigures());
        this.clearSelection();
        this.getDrawing().removeAll(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paste() {
        block11: {
            if (this.domFactory == null) {
                this.getToolkit().beep();
                return;
            }
            try {
                ArrayList<Figure> arrayList = new ArrayList<Figure>();
                DataFlavor dataFlavor = new DataFlavor("application/x-drawing-clip", "Drawing Clip");
                Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                if (transferable.isDataFlavorSupported(dataFlavor)) {
                    CompositeEdit compositeEdit = new CompositeEdit("Paste");
                    this.getDrawing().fireUndoableEditHappened(compositeEdit);
                    for (Figure object2 : new LinkedList<Figure>(this.getSelectedFigures())) {
                        this.getDrawing().remove(object2);
                    }
                    Object object = null;
                    try {
                        object = (InputStream)transferable.getTransferData(dataFlavor);
                        NanoXMLLiteDOMInput nanoXMLLiteDOMInput = new NanoXMLLiteDOMInput(this.domFactory, (InputStream)object);
                        nanoXMLLiteDOMInput.openElement("DrawingClip");
                        int n = nanoXMLLiteDOMInput.getElementCount();
                        for (int i = 0; i < n; ++i) {
                            Figure figure = (Figure)nanoXMLLiteDOMInput.readObject(i);
                            this.getDrawing().add(figure);
                            arrayList.add(figure);
                        }
                    }
                    finally {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                    this.clearSelection();
                    this.addToSelection(arrayList);
                    this.getDrawing().fireUndoableEditHappened(compositeEdit);
                    break block11;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void duplicate() {
        Collection<Figure> collection = this.getDrawing().sort(this.getSelectedFigures());
        HashMap<Figure, Figure> hashMap = new HashMap<Figure, Figure>(collection.size());
        this.clearSelection();
        Drawing drawing = this.getDrawing();
        ArrayList<Figure> arrayList = new ArrayList<Figure>(collection.size());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(5.0, 5.0);
        for (Figure figure : collection) {
            Figure figure2 = (Figure)figure.clone();
            figure2.basicTransform(affineTransform);
            arrayList.add(figure2);
            hashMap.put(figure, figure2);
            drawing.add(figure2);
        }
        for (Figure figure : arrayList) {
            figure.remap(hashMap);
        }
        this.addToSelection(arrayList);
    }

    @Override
    public void removeNotify(DrawingEditor drawingEditor) {
        this.editor = null;
        this.repaint();
    }

    @Override
    public void addNotify(DrawingEditor drawingEditor) {
        this.editor = drawingEditor;
        this.repaint();
    }
}

