/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.BezierNodeHandle;
import org.jhotdraw.draw.ChangeConnectionEndHandle;
import org.jhotdraw.draw.ChangeConnectionStartHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.LineFigure;
import org.jhotdraw.draw.Liner;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineConnectionFigure
extends LineFigure
implements ConnectionFigure {
    private Connector startConnector;
    private Connector endConnector;
    private Liner liner;
    private ConnectionHandler connectionHandler = new ConnectionHandler(this);

    @Override
    public void basicTransform(AffineTransform affineTransform) {
        super.basicTransform(affineTransform);
        this.updateConnection();
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        ArrayList<Handle> arrayList = new ArrayList<Handle>(this.getNodeCount());
        switch (n) {
            case 0: {
                if (this.getLiner() == null) {
                    int n2 = this.getNodeCount() - 1;
                    for (int i = 1; i < n2; ++i) {
                        arrayList.add(new BezierNodeHandle(this, i));
                    }
                }
                arrayList.add(new ChangeConnectionStartHandle(this));
                arrayList.add(new ChangeConnectionEndHandle(this));
            }
        }
        return arrayList;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public void updateConnection() {
        Point2D.Double double_;
        this.willChange();
        if (this.getStartConnector() != null && (double_ = this.getStartConnector().findStart(this)) != null) {
            this.basicSetStartPoint(double_);
        }
        if (this.getEndConnector() != null && (double_ = this.getEndConnector().findEnd(this)) != null) {
            this.basicSetEndPoint(double_);
        }
        this.changed();
    }

    @Override
    public void validate() {
        super.validate();
        this.lineout();
    }

    @Override
    public boolean canConnect(Figure figure, Figure figure2) {
        return figure.canConnect() && figure2.canConnect();
    }

    @Override
    public boolean connectsSame(ConnectionFigure connectionFigure) {
        return connectionFigure.getStartConnector() == this.getStartConnector() && connectionFigure.getEndConnector() == this.getEndConnector();
    }

    @Override
    public Connector getEndConnector() {
        return this.endConnector;
    }

    @Override
    public Figure getEndFigure() {
        return this.endConnector == null ? null : this.endConnector.getOwner();
    }

    @Override
    public Connector getStartConnector() {
        return this.startConnector;
    }

    @Override
    public Figure getStartFigure() {
        return this.startConnector == null ? null : this.startConnector.getOwner();
    }

    @Override
    public final void setEndConnector(final Connector connector) {
        final Connector connector2 = this.endConnector;
        if (connector != connector2) {
            this.willChange();
            this.basicSetEndConnector(connector);
            this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                public String getPresentationName() {
                    return "End-Verbindung setzen";
                }

                public void undo() throws CannotUndoException {
                    super.undo();
                    LineConnectionFigure.this.willChange();
                    LineConnectionFigure.this.basicSetEndConnector(connector2);
                    LineConnectionFigure.this.changed();
                }

                public void redo() throws CannotUndoException {
                    super.redo();
                    LineConnectionFigure.this.willChange();
                    LineConnectionFigure.this.basicSetEndConnector(connector);
                    LineConnectionFigure.this.changed();
                }
            });
            this.changed();
        }
    }

    protected void basicSetEndConnector(Connector connector) {
        if (connector != this.endConnector) {
            if (this.endConnector != null) {
                this.getEndFigure().removeFigureListener(this.connectionHandler);
                if (this.getStartFigure() != null) {
                    this.handleDisconnect(this.getStartFigure(), this.getEndFigure());
                }
            }
            this.endConnector = connector;
            if (this.endConnector != null) {
                this.getEndFigure().addFigureListener(this.connectionHandler);
                if (this.getStartFigure() != null && this.getEndFigure() != null) {
                    this.handleConnect(this.getStartFigure(), this.getEndFigure());
                    this.updateConnection();
                }
            }
        }
    }

    @Override
    public final void setStartConnector(final Connector connector) {
        final Connector connector2 = this.startConnector;
        if (connector != connector2) {
            this.willChange();
            this.basicSetStartConnector(connector);
            this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                public String getPresentationName() {
                    return "Start-Verbindung setzen";
                }

                public void undo() throws CannotUndoException {
                    super.undo();
                    LineConnectionFigure.this.willChange();
                    LineConnectionFigure.this.basicSetStartConnector(connector2);
                    LineConnectionFigure.this.changed();
                }

                public void redo() throws CannotUndoException {
                    super.redo();
                    LineConnectionFigure.this.willChange();
                    LineConnectionFigure.this.basicSetStartConnector(connector);
                    LineConnectionFigure.this.changed();
                }
            });
            this.changed();
        }
    }

    public void basicSetStartConnector(Connector connector) {
        if (connector != this.startConnector) {
            if (this.startConnector != null) {
                this.getStartFigure().removeFigureListener(this.connectionHandler);
                if (this.getEndFigure() != null) {
                    this.handleDisconnect(this.getStartFigure(), this.getEndFigure());
                }
            }
            this.startConnector = connector;
            if (this.startConnector != null) {
                this.getStartFigure().addFigureListener(this.connectionHandler);
                if (this.getStartFigure() != null && this.getEndFigure() != null) {
                    this.handleConnect(this.getStartFigure(), this.getEndFigure());
                    this.updateConnection();
                }
            }
        }
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
    }

    @Override
    public void removeNotify(Drawing drawing) {
        super.removeNotify(drawing);
    }

    protected void handleDisconnect(Figure figure, Figure figure2) {
    }

    protected void handleConnect(Figure figure, Figure figure2) {
    }

    @Override
    public LineConnectionFigure clone() {
        LineConnectionFigure lineConnectionFigure = (LineConnectionFigure)super.clone();
        lineConnectionFigure.connectionHandler = new ConnectionHandler(lineConnectionFigure);
        if (this.liner != null) {
            lineConnectionFigure.liner = this.liner.clone();
        }
        if (this.startConnector != null) {
            lineConnectionFigure.startConnector = (Connector)this.startConnector.clone();
            lineConnectionFigure.getStartFigure().addFigureListener(lineConnectionFigure.connectionHandler);
        }
        if (this.endConnector != null) {
            lineConnectionFigure.endConnector = (Connector)this.endConnector.clone();
            lineConnectionFigure.getEndFigure().addFigureListener(lineConnectionFigure.connectionHandler);
        }
        if (lineConnectionFigure.startConnector != null && lineConnectionFigure.endConnector != null) {
            lineConnectionFigure.handleConnect(lineConnectionFigure.getStartFigure(), lineConnectionFigure.getEndFigure());
            lineConnectionFigure.updateConnection();
        }
        return lineConnectionFigure;
    }

    @Override
    public void remap(Map map) {
        this.willChange();
        super.remap(map);
        Figure figure = null;
        Figure figure2 = null;
        if (this.getStartFigure() != null && (figure = (Figure)map.get(this.getStartFigure())) == null) {
            figure = this.getStartFigure();
        }
        if (this.getEndFigure() != null && (figure2 = (Figure)map.get(this.getEndFigure())) == null) {
            figure2 = this.getEndFigure();
        }
        if (figure != null) {
            this.setStartConnector(figure.findCompatibleConnector(this.getStartConnector(), true));
        }
        if (figure2 != null) {
            this.setEndConnector(figure2.findCompatibleConnector(this.getEndConnector(), false));
        }
        this.updateConnection();
        this.changed();
    }

    @Override
    public boolean canConnect(Figure figure) {
        return figure.canConnect();
    }

    @Override
    public boolean handleMouseClick(Point2D.Double double_, MouseEvent mouseEvent, DrawingView drawingView) {
        if (this.getLiner() == null && mouseEvent.getClickCount() == 2) {
            this.willChange();
            final int n = this.basicSplitSegment(double_, (float)(5.0 / drawingView.getScaleFactor()));
            if (n != -1) {
                final BezierPath.Node node = this.getNode(n);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    public void redo() throws CannotRedoException {
                        super.redo();
                        LineConnectionFigure.this.willChange();
                        LineConnectionFigure.this.basicAddNode(n, node);
                        LineConnectionFigure.this.changed();
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        LineConnectionFigure.this.willChange();
                        LineConnectionFigure.this.basicRemoveNode(n);
                        LineConnectionFigure.this.changed();
                    }
                });
                this.changed();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void readPoints(DOMInput dOMInput) throws IOException {
        super.readPoints(dOMInput);
        dOMInput.openElement("startConnector");
        this.setStartConnector((Connector)dOMInput.readObject());
        dOMInput.closeElement();
        dOMInput.openElement("endConnector");
        this.setEndConnector((Connector)dOMInput.readObject());
        dOMInput.closeElement();
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        this.readPoints(dOMInput);
        this.readAttributes(dOMInput);
        this.readLiner(dOMInput);
    }

    protected void readLiner(DOMInput dOMInput) throws IOException {
        if (dOMInput.getElementCount("liner") > 0) {
            dOMInput.openElement("liner");
            this.liner = (Liner)dOMInput.readObject();
            dOMInput.closeElement();
        }
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        this.writePoints(dOMOutput);
        this.writeAttributes(dOMOutput);
        this.writeLiner(dOMOutput);
    }

    protected void writeLiner(DOMOutput dOMOutput) throws IOException {
        if (this.liner != null) {
            dOMOutput.openElement("liner");
            dOMOutput.writeObject(this.liner);
            dOMOutput.closeElement();
        }
    }

    @Override
    protected void writePoints(DOMOutput dOMOutput) throws IOException {
        super.writePoints(dOMOutput);
        dOMOutput.openElement("startConnector");
        dOMOutput.writeObject(this.getStartConnector());
        dOMOutput.closeElement();
        dOMOutput.openElement("endConnector");
        dOMOutput.writeObject(this.getEndConnector());
        dOMOutput.closeElement();
    }

    @Override
    public void setLiner(Liner liner) {
        this.willChange();
        this.liner = liner;
        this.changed();
    }

    @Override
    public void basicSetNode(int n, BezierPath.Node node) {
        if (n != 0 && n != this.getPointCount() - 1) {
            Point2D.Double double_;
            if (this.getStartConnector() != null && (double_ = this.getStartConnector().findStart(this)) != null) {
                this.basicSetStartPoint(double_);
            }
            if (this.getEndConnector() != null && (double_ = this.getEndConnector().findEnd(this)) != null) {
                this.basicSetEndPoint(double_);
            }
        }
        super.basicSetNode(n, node);
    }

    @Override
    public void lineout() {
        if (this.liner != null) {
            this.liner.lineout(this);
        }
    }

    @Override
    public BezierPath getBezierPath() {
        return this.path;
    }

    @Override
    public Liner getLiner() {
        return this.liner;
    }

    @Override
    public void setStartPoint(Point2D.Double double_) {
        this.setPoint(0, double_);
    }

    @Override
    public void setPoint(int n, Point2D.Double double_) {
        this.setPoint(n, 0, double_);
    }

    @Override
    public void setEndPoint(Point2D.Double double_) {
        this.setPoint(this.getPointCount() - 1, double_);
    }

    public void reverseConnection() {
        if (this.startConnector != null && this.endConnector != null) {
            this.handleDisconnect(this.startConnector.getOwner(), this.endConnector.getOwner());
            Connector connector = this.startConnector;
            this.startConnector = this.endConnector;
            this.endConnector = connector;
            Point2D.Double double_ = this.getStartPoint();
            this.setStartPoint(this.getEndPoint());
            this.setEndPoint(double_);
            this.handleConnect(this.startConnector.getOwner(), this.endConnector.getOwner());
            this.updateConnection();
        }
    }

    private static class ConnectionHandler
    implements FigureListener {
        private LineConnectionFigure owner;

        private ConnectionHandler(LineConnectionFigure lineConnectionFigure) {
            this.owner = lineConnectionFigure;
        }

        public void figureRequestRemove(FigureEvent figureEvent) {
        }

        public void figureRemoved(FigureEvent figureEvent) {
            this.owner.fireFigureRequestRemove();
        }

        public void figureChanged(FigureEvent figureEvent) {
            if (figureEvent.getSource() == this.owner.getStartFigure() || figureEvent.getSource() == this.owner.getEndFigure()) {
                this.owner.willChange();
                this.owner.updateConnection();
                this.owner.changed();
            }
        }

        public void figureAdded(FigureEvent figureEvent) {
        }

        public void figureAttributeChanged(FigureEvent figureEvent) {
        }

        public void figureAreaInvalidated(FigureEvent figureEvent) {
        }
    }
}

