/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.geom.Geom;

public class RectangleFigure
extends AttributedFigure {
    private Rectangle2D.Double rectangle;

    public RectangleFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public RectangleFigure(double d, double d2, double d3, double d4) {
        this.rectangle = new Rectangle2D.Double(d, d2, d3, d4);
    }

    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.rectangle.clone();
        return double_;
    }

    protected void drawFill(Graphics2D graphics2D) {
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.rectangle.clone();
        double d = AttributeKeys.getPerpendicularFillGrowth(this);
        Geom.grow(double_, d, d);
        graphics2D.fill(double_);
    }

    protected void drawStroke(Graphics2D graphics2D) {
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.rectangle.clone();
        double d = AttributeKeys.getPerpendicularDrawGrowth(this);
        Geom.grow(double_, d, d);
        graphics2D.draw(double_);
    }

    public Rectangle2D.Double getFigureDrawBounds() {
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.rectangle.clone();
        double d = AttributeKeys.getPerpendicularHitGrowth(this) + 1.0;
        Geom.grow(double_, d, d);
        return double_;
    }

    public boolean contains(Point2D.Double double_) {
        Rectangle2D.Double double_2 = (Rectangle2D.Double)this.rectangle.clone();
        double d = AttributeKeys.getPerpendicularHitGrowth(this) + 1.0;
        Geom.grow(double_2, d, d);
        return double_2.contains(double_);
    }

    public void basicSetBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.rectangle.x = Math.min(double_.x, double_2.x);
        this.rectangle.y = Math.min(double_.y, double_2.y);
        this.rectangle.width = Math.max(0.1, Math.abs(double_2.x - double_.x));
        this.rectangle.height = Math.max(0.1, Math.abs(double_2.y - double_.y));
    }

    public void basicTransform(AffineTransform affineTransform) {
        Point2D.Double double_ = this.getStartPoint();
        Point2D.Double double_2 = this.getEndPoint();
        this.basicSetBounds((Point2D.Double)affineTransform.transform(double_, double_), (Point2D.Double)affineTransform.transform(double_2, double_2));
    }

    public RectangleFigure clone() {
        RectangleFigure rectangleFigure = (RectangleFigure)super.clone();
        rectangleFigure.rectangle = (Rectangle2D.Double)this.rectangle.clone();
        return rectangleFigure;
    }

    public void restoreTo(Object object) {
        Rectangle2D.Double double_ = (Rectangle2D.Double)object;
        this.rectangle.x = double_.x;
        this.rectangle.y = double_.y;
        this.rectangle.width = double_.width;
        this.rectangle.height = double_.height;
    }

    public Object getRestoreData() {
        return this.rectangle.clone();
    }
}

