/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractLocator;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.geom.Insets2DDouble;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class RelativeLocator
extends AbstractLocator {
    double relativeX;
    double relativeY;

    public RelativeLocator() {
        this.relativeX = 0.0;
        this.relativeY = 0.0;
    }

    public RelativeLocator(double d, double d2) {
        this.relativeX = d;
        this.relativeY = d2;
    }

    public Point2D.Double locate(Figure figure) {
        Insets2DDouble insets2DDouble;
        Rectangle2D.Double double_ = figure.getBounds();
        if (figure.getDecorator() != null && (insets2DDouble = AttributeKeys.DECORATOR_INSETS.get(figure)) != null) {
            double_.x -= insets2DDouble.left;
            double_.y -= insets2DDouble.top;
            double_.width += insets2DDouble.left + insets2DDouble.right;
            double_.height += insets2DDouble.top + insets2DDouble.bottom;
        }
        return new Point2D.Double(double_.x + double_.width * this.relativeX, double_.y + double_.height * this.relativeY);
    }

    public static Locator east() {
        return new RelativeLocator(1.0, 0.5);
    }

    public static Locator north() {
        return new RelativeLocator(0.5, 0.0);
    }

    public static Locator west() {
        return new RelativeLocator(0.0, 0.5);
    }

    public static Locator northEast() {
        return new RelativeLocator(1.0, 0.0);
    }

    public static Locator northWest() {
        return new RelativeLocator(0.0, 0.0);
    }

    public static Locator south() {
        return new RelativeLocator(0.5, 1.0);
    }

    public static Locator southEast() {
        return new RelativeLocator(1.0, 1.0);
    }

    public static Locator southWest() {
        return new RelativeLocator(0.0, 1.0);
    }

    public static Locator center() {
        return new RelativeLocator(0.5, 0.5);
    }

    public void write(DOMOutput dOMOutput) {
        dOMOutput.addAttribute("relativeX", this.relativeX, 0.5);
        dOMOutput.addAttribute("relativeY", this.relativeY, 0.5);
    }

    public void read(DOMInput dOMInput) {
        this.relativeX = dOMInput.getAttribute("relativeX", 0.5);
        this.relativeY = dOMInput.getAttribute("relativeY", 0.5);
    }
}

