/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.DoubleStroke;

public class GrowStroke
extends DoubleStroke {
    private float grow;

    public GrowStroke(float f, float f2) {
        super(f * 2.0f, 1.0f, 2, 2, f2, null, 0.0f);
        this.grow = f;
    }

    public Shape createStrokedShape(Shape shape) {
        BezierPath bezierPath = new BezierPath();
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        double[] dArray = new double[6];
        PathIterator pathIterator = shape.getPathIterator(null, 0.1);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    if (bezierPath.size() != 0) {
                        this.traceStroke(bezierPath, generalPath, generalPath2);
                    }
                    bezierPath.clear();
                    bezierPath.moveTo(dArray[0], dArray[1]);
                    break;
                }
                case 1: {
                    if (dArray[0] == ((BezierPath.Node)bezierPath.get((int)(bezierPath.size() - 1))).x[0] && dArray[1] == ((BezierPath.Node)bezierPath.get((int)(bezierPath.size() - 1))).y[0]) break;
                    bezierPath.lineTo(dArray[0], dArray[1]);
                    break;
                }
                case 2: {
                    bezierPath.quadTo(dArray[0], dArray[1], dArray[2], dArray[3]);
                    break;
                }
                case 3: {
                    bezierPath.curveTo(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    break;
                }
                case 4: {
                    bezierPath.setClosed(true);
                }
            }
            pathIterator.next();
        }
        if (bezierPath.size() > 1) {
            this.traceStroke(bezierPath, generalPath, generalPath2);
        }
        if (generalPath.getBounds2D().contains(generalPath2.getBounds2D())) {
            return this.grow > 0.0f ? generalPath : generalPath2;
        }
        return this.grow > 0.0f ? generalPath2 : generalPath;
    }
}

