/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.net.figures;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractConnector;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.ConnectionHandle;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.LocatorConnector;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2DDouble;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFigure
extends TextFigure {
    private LinkedList<AbstractConnector> connectors;
    private static LocatorConnector north;
    private static LocatorConnector south;
    private static LocatorConnector east;
    private static LocatorConnector west;

    public NodeFigure() {
        RectangleFigure rectangleFigure = new RectangleFigure();
        this.setDecorator(rectangleFigure);
        this.createConnectors();
        this.setDrawDecoratorFirst(true);
        AttributeKeys.DECORATOR_INSETS.set(this, new Insets2DDouble(6.0, 10.0, 6.0, 10.0));
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.net.Labels");
        this.setText(resourceBundleUtil.getString("nodeDefaultName"));
    }

    private void createConnectors() {
        this.connectors = new LinkedList();
        this.connectors.add(new LocatorConnector(this, new RelativeLocator(0.5, 0.0)));
        this.connectors.add(new LocatorConnector(this, new RelativeLocator(0.5, 1.0)));
        this.connectors.add(new LocatorConnector(this, new RelativeLocator(1.0, 0.5)));
        this.connectors.add(new LocatorConnector(this, new RelativeLocator(0.0, 0.5)));
        for (AbstractConnector abstractConnector : this.connectors) {
            abstractConnector.setVisible(true);
        }
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        if (n == 0) {
            linkedList.add(new MoveHandle(this, RelativeLocator.northWest()));
            linkedList.add(new MoveHandle(this, RelativeLocator.northEast()));
            linkedList.add(new MoveHandle(this, RelativeLocator.southWest()));
            linkedList.add(new MoveHandle(this, RelativeLocator.southEast()));
            linkedList.add(new ConnectionHandle(this, RelativeLocator.north(), new LineConnectionFigure()));
            linkedList.add(new ConnectionHandle(this, RelativeLocator.east(), new LineConnectionFigure()));
            linkedList.add(new ConnectionHandle(this, RelativeLocator.south(), new LineConnectionFigure()));
            linkedList.add(new ConnectionHandle(this, RelativeLocator.west(), new LineConnectionFigure()));
        }
        return linkedList;
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        Rectangle2D.Double double_ = super.getFigureDrawBounds();
        Geom.grow(double_, 10.0, 10.0);
        return double_;
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        double d = Double.MAX_VALUE;
        AbstractConnector abstractConnector = null;
        for (AbstractConnector abstractConnector2 : this.connectors) {
            Point2D.Double double_2 = Geom.center(abstractConnector2.getBounds());
            double d2 = Geom.length2(double_.x, double_.y, double_2.x, double_2.y);
            if (!(d2 < d)) continue;
            d = d2;
            abstractConnector = abstractConnector2;
        }
        return abstractConnector;
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return this.connectors.getFirst();
    }

    @Override
    public NodeFigure clone() {
        NodeFigure nodeFigure = (NodeFigure)super.clone();
        nodeFigure.createConnectors();
        return nodeFigure;
    }

    @Override
    protected void drawConnectors(Graphics2D graphics2D) {
        for (AbstractConnector abstractConnector : this.connectors) {
            abstractConnector.draw(graphics2D);
        }
    }

    @Override
    public int getLayer() {
        return -1;
    }

    @Override
    public void setAttribute(AttributeKey attributeKey, Object object) {
        super.setAttribute(attributeKey, object);
        if (this.getDecorator() != null) {
            this.getDecorator().setAttribute(attributeKey, object);
        }
    }
}

