/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.jhotdraw.util.LocaleUtil;

public class ResourceBundleUtil {
    private ResourceBundle resource;
    private Class baseClass = this.getClass();

    public ResourceBundleUtil(ResourceBundle resourceBundle) {
        this.resource = resourceBundle;
    }

    public ResourceBundle getBundle() {
        return this.resource;
    }

    public String getString(String string) {
        try {
            return this.resource.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public Integer getInteger(String string) {
        try {
            return Integer.valueOf(this.resource.getString(string));
        }
        catch (MissingResourceException missingResourceException) {
            return new Integer(-1);
        }
    }

    public ImageIcon getImageIcon(String string, Class clazz) {
        try {
            Object object;
            String string2 = this.resource.getString(string + ".icon");
            if (string2.equals("")) {
                return null;
            }
            if (!string2.startsWith("/")) {
                try {
                    object = this.resource.getString("$imageDir");
                    if (!((String)object).endsWith("/")) {
                        object = (String)object + "/";
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    object = "";
                }
                string2 = (String)object + string2;
            }
            return (object = clazz.getResource(string2)) == null ? null : new ImageIcon((URL)object);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public char getMnemonic(String string) {
        String string2 = this.resource.getString(string);
        return string2 == null || string2.length() == 0 ? (char)'\u0000' : string2.charAt(0);
    }

    public char getMnem(String string) {
        String string2;
        try {
            string2 = this.resource.getString(string + ".mnem");
        }
        catch (MissingResourceException missingResourceException) {
            string2 = null;
        }
        return string2 == null || string2.length() == 0 ? (char)'\u0000' : string2.charAt(0);
    }

    public String getTip(String string) {
        try {
            return this.resource.getString(string + ".tip");
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public KeyStroke getKeyStroke(String string) {
        KeyStroke keyStroke = null;
        try {
            String string2 = this.resource.getString(string);
            keyStroke = string2 == null ? (KeyStroke)null : KeyStroke.getKeyStroke(string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return keyStroke;
    }

    public KeyStroke getAcc(String string) {
        KeyStroke keyStroke = null;
        try {
            String string2 = this.resource.getString(string + ".acc");
            keyStroke = string2 == null ? (KeyStroke)null : KeyStroke.getKeyStroke(string2);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return keyStroke;
    }

    public String getFormatted(String string, String string2) {
        return MessageFormat.format(this.resource.getString(string), string2);
    }

    public String getFormatted(String string, Object ... objectArray) {
        return MessageFormat.format(this.resource.getString(string), objectArray);
    }

    public static ResourceBundleUtil getLAFBundle(String string) throws MissingResourceException {
        return ResourceBundleUtil.getLAFBundle(string, LocaleUtil.getDefault());
    }

    public void setBaseClass(Class clazz) {
        this.baseClass = clazz;
    }

    public Class getBaseClass() {
        return this.baseClass;
    }

    public void configureAction(Action action, String string) {
        this.configureAction(action, string, this.getBaseClass());
    }

    public void configureAction(Action action, String string, Class clazz) {
        action.putValue("Name", this.getString(string));
        action.putValue("AcceleratorKey", this.getAcc(string));
        action.putValue("MnemonicKey", new Integer(this.getMnem(string)));
        action.putValue("SmallIcon", this.getImageIcon(string, clazz));
    }

    public void configureButton(AbstractButton abstractButton, String string) {
        this.configureButton(abstractButton, string, this.getBaseClass());
    }

    public void configureButton(AbstractButton abstractButton, String string, Class clazz) {
        abstractButton.setText(this.getString(string));
        abstractButton.setIcon(this.getImageIcon(string, clazz));
        abstractButton.setToolTipText(this.getTip(string));
    }

    public void configureToolBarButton(AbstractButton abstractButton, String string) {
        this.configureToolBarButton(abstractButton, string, this.getBaseClass());
    }

    public void configureToolBarButton(AbstractButton abstractButton, String string, Class clazz) {
        abstractButton.setText(null);
        abstractButton.setIcon(this.getImageIcon(string, clazz));
        abstractButton.setToolTipText(this.getTip(string));
    }

    public void configureMenu(JMenuItem jMenuItem, String string) {
        jMenuItem.setText(this.getString(string));
        if (!(jMenuItem instanceof JMenu)) {
            jMenuItem.setAccelerator(this.getAcc(string));
        }
        jMenuItem.setMnemonic(this.getMnem(string));
    }

    public static ResourceBundleUtil getLAFBundle(String string, Locale locale) throws MissingResourceException {
        ResourceBundleUtil resourceBundleUtil;
        try {
            resourceBundleUtil = new ResourceBundleUtil(ResourceBundle.getBundle(string + '_' + UIManager.getLookAndFeel().getID(), locale));
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundleUtil = new ResourceBundleUtil(ResourceBundle.getBundle(string, locale));
        }
        return resourceBundleUtil;
    }
}

