/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMStorable;

public class DefaultDOMFactory
implements DOMFactory {
    private static final HashMap<Class, String> classToNameMap = new HashMap();
    private static final HashMap<String, Object> nameToPrototypeMap = new HashMap();
    private static final HashMap<Class, String> enumClassToNameMap = new HashMap();
    private static final HashMap<String, Class> nameToEnumClassMap = new HashMap();
    private static final HashMap<Enum, String> enumToValueMap = new HashMap();
    private static final HashMap<String, Set<Enum>> valueToEnumMap = new HashMap();

    public void addStorableClass(String string, Class clazz) {
        nameToPrototypeMap.put(string, clazz);
        classToNameMap.put(clazz, string);
    }

    public void addStorable(String string, DOMStorable dOMStorable) {
        nameToPrototypeMap.put(string, dOMStorable);
        classToNameMap.put(dOMStorable.getClass(), string);
    }

    public void addEnumClass(String string, Class clazz) {
        enumClassToNameMap.put(clazz, string);
        nameToEnumClassMap.put(string, clazz);
    }

    public void addEnum(String string, Enum enum_) {
        Set<Object> set;
        enumToValueMap.put(enum_, string);
        if (valueToEnumMap.containsKey(string)) {
            set = valueToEnumMap.get(string);
        } else {
            set = new HashSet();
            valueToEnumMap.put(string, set);
        }
        set.add(enum_);
    }

    public Object create(String string) {
        Object object = nameToPrototypeMap.get(string);
        if (object == null) {
            throw new IllegalArgumentException("Storable name not known to factory: " + string);
        }
        if (object instanceof Class) {
            try {
                return ((Class)object).newInstance();
            }
            catch (Exception exception) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Storable class not instantiable by factory: " + string);
                illegalArgumentException.initCause(exception);
                throw illegalArgumentException;
            }
        }
        try {
            return object.getClass().getMethod("clone", null).invoke(object, (Object[])null);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Storable prototype not cloneable by factory. Name: " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public String getName(DOMStorable dOMStorable) {
        String string = classToNameMap.get(dOMStorable.getClass());
        if (string == null) {
            throw new IllegalArgumentException("Storable class not known to factory. Storable:" + dOMStorable + " Factory:" + this.getClass());
        }
        return string;
    }

    public String getEnumName(Enum enum_) {
        String string = enumClassToNameMap.get(enum_.getClass());
        if (string == null) {
            throw new IllegalArgumentException("Enum class not known to factory:" + enum_.getClass());
        }
        return string;
    }

    public String getEnumValue(Enum enum_) {
        return enumToValueMap.containsKey(enum_) ? enumToValueMap.get(enum_) : enum_.toString();
    }

    public Enum createEnum(String string, String string2) {
        Class clazz = nameToEnumClassMap.get(string);
        if (clazz == null) {
            throw new IllegalArgumentException("Enum name not known to factory:" + string);
        }
        Set<Enum> set = valueToEnumMap.get(string2);
        if (set == null) {
            return Enum.valueOf(clazz, string2);
        }
        for (Enum enum_ : set) {
            if (enum_.getClass() != clazz) continue;
            return enum_;
        }
        throw new IllegalArgumentException("Enum value not known to factory:" + string2);
    }
}

