/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.BitSet;
import java.util.Random;

public class Chromosome {
    private static final int DEFAULT_MUTATION_RATE = 1000;
    private final int mutationRate;
    private final BitSet genes;
    private final int numberOfGenes;
    private static Random generator = new Random();

    public Chromosome(BitSet bitSet, int n) {
        if (bitSet == null) {
            throw new IllegalArgumentException("Genes cannot be null.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Chromosome length must be positive");
        }
        this.genes = bitSet;
        this.numberOfGenes = n;
        this.mutationRate = 1000;
    }

    public Chromosome(BitSet bitSet, int n, int n2) {
        if (bitSet == null) {
            throw new IllegalArgumentException("Genes cannot be null.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Chromosomes must have a positive length");
        }
        this.genes = bitSet;
        this.numberOfGenes = n;
        this.mutationRate = n2;
    }

    public Chromosome reproduce() {
        return new Chromosome((BitSet)this.genes.clone(), this.numberOfGenes, this.mutationRate);
    }

    public void crossover(Chromosome chromosome) {
        int n;
        int n2 = n = generator.nextInt(this.numberOfGenes);
        while (n2 < this.numberOfGenes) {
            boolean bl = this.genes.get(n2);
            if (chromosome.genes.get(n2)) {
                this.genes.set(n2);
            } else {
                this.genes.clear(n2);
            }
            if (bl) {
                chromosome.genes.set(n2);
            } else {
                chromosome.genes.clear(n2);
            }
            ++n2;
        }
    }

    public void mutate() {
        int n = 0;
        while (n < this.numberOfGenes) {
            if (generator.nextInt(this.mutationRate) == 0) {
                if (this.genes.get(n)) {
                    this.genes.clear(n);
                } else {
                    this.genes.set(n);
                }
            }
            ++n;
        }
    }

    public boolean getAllele(int n) {
        return this.genes.get(n);
    }

    public int size() {
        return this.numberOfGenes;
    }

    public String toString() {
        return this.genes.toString();
    }

    public static Chromosome randomInitialChromosome(int n) {
        return Chromosome.randomInitialChromosome(n, 1000);
    }

    public static Chromosome randomInitialChromosome(int n, int n2) {
        BitSet bitSet = new BitSet(n);
        int n3 = 0;
        while (n3 < n) {
            if (generator.nextInt(2) == 0) {
                bitSet.set(n3);
            } else {
                bitSet.clear(n3);
            }
            ++n3;
        }
        return new Chromosome(bitSet, n, n2);
    }
}

