/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.jgap.Chromosome;
import org.jgap.FitnessFunction;
import org.jgap.NaturalSelector;

public class Genotype {
    protected static Random generator = new Random();
    protected Chromosome[] chromosomes;
    protected final FitnessFunction objectiveFunction;
    protected final NaturalSelector populationSelector;
    protected List workingPool;

    public Genotype(Chromosome[] chromosomeArray, FitnessFunction fitnessFunction, NaturalSelector naturalSelector) {
        this.chromosomes = chromosomeArray;
        this.objectiveFunction = fitnessFunction;
        this.populationSelector = naturalSelector;
        this.workingPool = new ArrayList();
    }

    public Chromosome[] getChromosomes() {
        return this.chromosomes;
    }

    public Chromosome getFittestChromosome() {
        if (this.chromosomes.length == 0) {
            return null;
        }
        Chromosome chromosome = this.chromosomes[0];
        int n = this.objectiveFunction.evaluate(chromosome);
        int n2 = 1;
        while (n2 < this.chromosomes.length) {
            int n3 = this.objectiveFunction.evaluate(this.chromosomes[n2]);
            if (n3 > n) {
                chromosome = this.chromosomes[n2];
                n = n3;
            }
            ++n2;
        }
        return chromosome;
    }

    public void evolve() {
        Chromosome chromosome;
        Object object;
        this.workingPool.removeAll(this.workingPool);
        int n = 0;
        while (n < this.chromosomes.length) {
            this.workingPool.add(this.chromosomes[n].reproduce());
            object = this.chromosomes[generator.nextInt(this.chromosomes.length)];
            chromosome = this.chromosomes[generator.nextInt(this.chromosomes.length)];
            ((Chromosome)object).crossover(chromosome);
            this.workingPool.add(object);
            this.workingPool.add(chromosome);
            ++n;
        }
        object = this.workingPool.iterator();
        while (object.hasNext()) {
            chromosome = (Chromosome)object.next();
            chromosome.mutate();
            this.populationSelector.add(chromosome, this.objectiveFunction.evaluate(chromosome));
        }
        this.chromosomes = this.populationSelector.select(this.chromosomes.length);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.chromosomes.length) {
            stringBuffer.append(this.chromosomes[n].toString());
            stringBuffer.append(" [");
            stringBuffer.append(this.objectiveFunction.evaluate(this.chromosomes[n]));
            stringBuffer.append("]");
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Genotype randomInitialGenotype(int n, int n2, FitnessFunction fitnessFunction, NaturalSelector naturalSelector) {
        Chromosome[] chromosomeArray = new Chromosome[n];
        int n3 = 0;
        while (n3 < n) {
            chromosomeArray[n3] = Chromosome.randomInitialChromosome(n2);
            ++n3;
        }
        return new Genotype(chromosomeArray, fitnessFunction, naturalSelector);
    }

    public static Genotype randomInitialGenotype(int n, int n2, int n3, FitnessFunction fitnessFunction, NaturalSelector naturalSelector) {
        Chromosome[] chromosomeArray = new Chromosome[n];
        int n4 = 0;
        while (n4 < n) {
            chromosomeArray[n4] = Chromosome.randomInitialChromosome(n2, n3);
            ++n4;
        }
        return new Genotype(chromosomeArray, fitnessFunction, naturalSelector);
    }
}

