/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.jgap.Chromosome;
import org.jgap.Counter;
import org.jgap.NaturalSelector;

public class WeightedRouletteSelector
implements NaturalSelector {
    private static Random generator = new Random();
    private HashMap population = new HashMap();
    private int totalInstances = 0;

    public void add(Chromosome chromosome, int n) {
        if (this.population.containsKey(chromosome)) {
            ((Counter)this.population.get(chromosome)).increment(n);
        } else {
            this.population.put(chromosome, new Counter(n));
        }
        this.totalInstances += n;
    }

    public Chromosome[] select(int n) {
        Chromosome[] chromosomeArray = new Chromosome[n];
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = generator.nextInt(this.totalInstances);
            ++n2;
        }
        Arrays.sort(nArray);
        Iterator iterator = this.population.keySet().iterator();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (iterator.hasNext() && n4 < nArray.length) {
            Chromosome chromosome = (Chromosome)iterator.next();
            n5 += ((Counter)this.population.get(chromosome)).getCount();
            while (n4 < nArray.length && n5 >= nArray[n4]) {
                chromosomeArray[n3] = chromosome;
                ++n3;
                ++n4;
            }
        }
        return chromosomeArray;
    }

    public void empty() {
        this.population.clear();
        this.totalInstances = 0;
    }
}

