/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.codecs;

import de.jarnbjo.ogg.CachedUrlStream;
import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.vorbis.IdentificationHeader;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;

public class CodecJOgg
implements ICodec {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final boolean XXX = false;
    private boolean endOfStream = false;
    private boolean initialized = false;
    private boolean reverseBytes = false;
    private CachedUrlStream cachedUrlStream = null;
    private LogicalOggStream myLogicalOggStream = null;
    private VorbisStream myVorbisStream = null;
    private OggInputStream myOggInputStream = null;
    private IdentificationHeader myIdentificationHeader = null;
    private AudioFormat myAudioFormat = null;
    private AudioInputStream myAudioInputStream = null;
    private SoundSystemLogger logger = SoundSystemConfig.getLogger();

    public void reverseByteOrder(boolean b) {
        this.reverseBytes = b;
    }

    public boolean initialize(URL url) {
        this.initialized(true, false);
        this.cleanup();
        if (url == null) {
            this.errorMessage("url null in method 'initialize'");
            this.cleanup();
            return false;
        }
        try {
            this.cachedUrlStream = new CachedUrlStream(url);
            this.myLogicalOggStream = (LogicalOggStream)this.cachedUrlStream.getLogicalStreams().iterator().next();
            this.myVorbisStream = new VorbisStream(this.myLogicalOggStream);
            this.myOggInputStream = new OggInputStream(this.myVorbisStream);
            this.myIdentificationHeader = this.myVorbisStream.getIdentificationHeader();
            this.myAudioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.myIdentificationHeader.getSampleRate(), 16, this.myIdentificationHeader.getChannels(), this.myIdentificationHeader.getChannels() * 2, this.myIdentificationHeader.getSampleRate(), true);
            this.myAudioInputStream = new AudioInputStream(this.myOggInputStream, this.myAudioFormat, -1L);
        }
        catch (Exception e) {
            this.errorMessage("Unable to set up input streams in method 'initialize'");
            this.printStackTrace(e);
            this.cleanup();
            return false;
        }
        if (this.myAudioInputStream == null) {
            this.errorMessage("Unable to set up audio input stream in method 'initialize'");
            this.cleanup();
            return false;
        }
        this.endOfStream(true, false);
        this.initialized(true, true);
        return true;
    }

    public boolean initialized() {
        return this.initialized(false, false);
    }

    public SoundBuffer read() {
        int bytesRead;
        if (this.myAudioInputStream == null) {
            this.endOfStream(true, true);
            return null;
        }
        AudioFormat audioFormat = this.myAudioInputStream.getFormat();
        if (audioFormat == null) {
            this.errorMessage("Audio Format null in method 'read'");
            this.endOfStream(true, true);
            return null;
        }
        int cnt = 0;
        byte[] streamBuffer = new byte[SoundSystemConfig.getStreamingBufferSize()];
        try {
            for (bytesRead = 0; !this.endOfStream(false, false) && bytesRead < streamBuffer.length; bytesRead += cnt) {
                cnt = this.myAudioInputStream.read(streamBuffer, bytesRead, streamBuffer.length - bytesRead);
                if (cnt > 0) continue;
                this.endOfStream(true, true);
                break;
            }
        }
        catch (IOException ioe) {
            this.endOfStream(true, true);
            return null;
        }
        if (bytesRead <= 0) {
            this.endOfStream(true, true);
            return null;
        }
        if (this.reverseBytes) {
            CodecJOgg.reverseBytes(streamBuffer, 0, bytesRead);
        }
        if (bytesRead < streamBuffer.length) {
            streamBuffer = CodecJOgg.trimArray(streamBuffer, bytesRead);
        }
        byte[] data = CodecJOgg.convertAudioBytes(streamBuffer, audioFormat.getSampleSizeInBits() == 16);
        SoundBuffer buffer = new SoundBuffer(data, audioFormat);
        return buffer;
    }

    public SoundBuffer readAll() {
        if (this.myAudioFormat == null) {
            this.errorMessage("Audio Format null in method 'readAll'");
            return null;
        }
        byte[] fullBuffer = null;
        int fileSize = this.myAudioFormat.getChannels() * (int)this.myAudioInputStream.getFrameLength() * this.myAudioFormat.getSampleSizeInBits() / 8;
        if (fileSize > 0) {
            fullBuffer = new byte[this.myAudioFormat.getChannels() * (int)this.myAudioInputStream.getFrameLength() * this.myAudioFormat.getSampleSizeInBits() / 8];
            int read = 0;
            try {
                for (int total = 0; (read = this.myAudioInputStream.read(fullBuffer, total, fullBuffer.length - total)) != -1 && total < fullBuffer.length; total += read) {
                }
            }
            catch (IOException e) {
                this.errorMessage("Exception thrown while reading from the AudioInputStream (location #1).");
                this.printStackTrace(e);
                return null;
            }
        }
        int bytesRead = 0;
        int cnt = 0;
        byte[] smallBuffer = null;
        smallBuffer = new byte[SoundSystemConfig.getFileChunkSize()];
        for (int totalBytes = 0; !this.endOfStream(false, false) && totalBytes < SoundSystemConfig.getMaxFileSize(); totalBytes += bytesRead) {
            cnt = 0;
            try {
                for (bytesRead = 0; bytesRead < smallBuffer.length; bytesRead += cnt) {
                    cnt = this.myAudioInputStream.read(smallBuffer, bytesRead, smallBuffer.length - bytesRead);
                    if (cnt > 0) continue;
                    this.endOfStream(true, true);
                    break;
                }
            }
            catch (IOException e) {
                this.errorMessage("Exception thrown while reading from the AudioInputStream (location #2).");
                this.printStackTrace(e);
                return null;
            }
            if (this.reverseBytes) {
                CodecJOgg.reverseBytes(smallBuffer, 0, bytesRead);
            }
            fullBuffer = CodecJOgg.appendByteArrays(fullBuffer, smallBuffer, bytesRead);
        }
        byte[] data = CodecJOgg.convertAudioBytes(fullBuffer, this.myAudioFormat.getSampleSizeInBits() == 16);
        SoundBuffer soundBuffer = new SoundBuffer(data, this.myAudioFormat);
        try {
            this.myAudioInputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return soundBuffer;
    }

    public boolean endOfStream() {
        return this.endOfStream(false, false);
    }

    public void cleanup() {
        if (this.myLogicalOggStream != null) {
            try {
                this.myLogicalOggStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.myVorbisStream != null) {
            try {
                this.myVorbisStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.myOggInputStream != null) {
            try {
                this.myOggInputStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.myAudioInputStream != null) {
            try {
                this.myAudioInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myLogicalOggStream = null;
        this.myVorbisStream = null;
        this.myOggInputStream = null;
        this.myAudioInputStream = null;
    }

    public AudioFormat getAudioFormat() {
        return this.myAudioFormat;
    }

    private synchronized boolean initialized(boolean action, boolean value) {
        if (action) {
            this.initialized = value;
        }
        return this.initialized;
    }

    private synchronized boolean endOfStream(boolean action, boolean value) {
        if (action) {
            this.endOfStream = value;
        }
        return this.endOfStream;
    }

    private static byte[] trimArray(byte[] array, int maxLength) {
        byte[] trimmedArray = null;
        if (array != null && array.length > maxLength) {
            trimmedArray = new byte[maxLength];
            System.arraycopy(array, 0, trimmedArray, 0, maxLength);
        }
        return trimmedArray;
    }

    private static byte[] convertAudioBytes(byte[] audio_bytes, boolean two_bytes_data) {
        ByteBuffer dest = ByteBuffer.allocateDirect(audio_bytes.length);
        dest.order(ByteOrder.nativeOrder());
        ByteBuffer src = ByteBuffer.wrap(audio_bytes);
        src.order(ByteOrder.LITTLE_ENDIAN);
        if (two_bytes_data) {
            ShortBuffer dest_short = dest.asShortBuffer();
            ShortBuffer src_short = src.asShortBuffer();
            while (src_short.hasRemaining()) {
                dest_short.put(src_short.get());
            }
        } else {
            while (src.hasRemaining()) {
                dest.put(src.get());
            }
        }
        dest.rewind();
        if (!dest.hasArray()) {
            byte[] arrayBackedBuffer = new byte[dest.capacity()];
            dest.get(arrayBackedBuffer);
            dest.clear();
            return arrayBackedBuffer;
        }
        return dest.array();
    }

    private static byte[] appendByteArrays(byte[] arrayOne, byte[] arrayTwo, int length) {
        byte[] newArray;
        if (arrayOne == null && arrayTwo == null) {
            return null;
        }
        if (arrayOne == null) {
            newArray = new byte[length];
            System.arraycopy(arrayTwo, 0, newArray, 0, length);
            arrayTwo = null;
        } else if (arrayTwo == null) {
            newArray = new byte[arrayOne.length];
            System.arraycopy(arrayOne, 0, newArray, 0, arrayOne.length);
            arrayOne = null;
        } else {
            newArray = new byte[arrayOne.length + length];
            System.arraycopy(arrayOne, 0, newArray, 0, arrayOne.length);
            System.arraycopy(arrayTwo, 0, newArray, arrayOne.length, length);
            arrayOne = null;
            arrayTwo = null;
        }
        return newArray;
    }

    public static void reverseBytes(byte[] buffer) {
        CodecJOgg.reverseBytes(buffer, 0, buffer.length);
    }

    public static void reverseBytes(byte[] buffer, int offset, int size) {
        for (int i = offset; i < offset + size; i += 2) {
            byte b = buffer[i];
            buffer[i] = buffer[i + 1];
            buffer[i + 1] = b;
        }
    }

    private void errorMessage(String message) {
        this.logger.errorMessage("CodecJOgg", message, 0);
    }

    private void printStackTrace(Exception e) {
        this.logger.printStackTrace(e, 1);
    }

    private class OggInputStream
    extends InputStream {
        private VorbisStream myVorbisStream;

        public OggInputStream(VorbisStream source) {
            this.myVorbisStream = source;
        }

        public int read() throws IOException {
            return 0;
        }

        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            try {
                return this.myVorbisStream.readPcm(buffer, offset, length);
            }
            catch (EndOfOggStreamException e) {
                return -1;
            }
        }
    }
}

