/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginRequest;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.logging.MdcInjectionFilter;

public class USER
extends AbstractCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        boolean success = false;
        ServerFtpStatistics stat = (ServerFtpStatistics)context.getFtpStatistics();
        try {
            session.resetState();
            String userName = request.getArgument();
            if (userName == null) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "USER", null));
                return;
            }
            MdcInjectionFilter.setProperty((IoSession)session, (String)"userName", (String)userName);
            User user = session.getUser();
            if (session.isLoggedIn()) {
                if (userName.equals(user.getName())) {
                    session.write((Object)LocalizedFtpReply.translate(session, request, context, 230, "USER", null));
                    success = true;
                } else {
                    session.write((Object)LocalizedFtpReply.translate(session, request, context, 530, "USER.invalid", null));
                }
                return;
            }
            boolean anonymous = userName.equals("anonymous");
            if (anonymous && !context.getConnectionConfig().isAnonymousLoginEnabled()) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 530, "USER.anonymous", null));
                return;
            }
            int currAnonLogin = stat.getCurrentAnonymousLoginNumber();
            int maxAnonLogin = context.getConnectionConfig().getMaxAnonymousLogins();
            if (anonymous && currAnonLogin >= maxAnonLogin) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 421, "USER.anonymous", null));
                return;
            }
            int currLogin = stat.getCurrentLoginNumber();
            int maxLogin = context.getConnectionConfig().getMaxLogins();
            if (maxLogin != 0 && currLogin >= maxLogin) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 421, "USER.login", null));
                return;
            }
            User configUser = context.getUserManager().getUserByName(userName);
            if (configUser != null) {
                ConcurrentLoginRequest loginRequest;
                InetAddress address = null;
                if (session.getRemoteAddress() instanceof InetSocketAddress) {
                    address = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
                }
                if (configUser.authorize((AuthorizationRequest)(loginRequest = new ConcurrentLoginRequest(stat.getCurrentUserLoginNumber(configUser) + 1, stat.getCurrentUserLoginNumber(configUser, address) + 1))) == null) {
                    session.write((Object)LocalizedFtpReply.translate(session, request, context, 421, "USER.login", null));
                    return;
                }
            }
            success = true;
            session.setUserArgument(userName);
            if (anonymous) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 331, "USER.anonymous", userName));
            } else {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 331, "USER", userName));
            }
        }
        finally {
            if (!success) {
                session.close(false).awaitUninterruptibly(10000L);
            }
        }
    }
}

