/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.nio;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.logging.LoggingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpLoggingFilter
extends LoggingFilter {
    private boolean maskPassword = true;
    private final Logger logger;

    public FtpLoggingFilter() {
        this(FtpLoggingFilter.class.getName());
    }

    public FtpLoggingFilter(Class<?> clazz) {
        this(clazz.getName());
    }

    public FtpLoggingFilter(String name) {
        super(name);
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        String request = (String)message;
        String logMessage = this.maskPassword ? ((request = request.trim().toUpperCase()).startsWith("PASS ") ? "PASS *****" : request) : request;
        this.logger.info("RECEIVED: {}", (Object)logMessage);
        nextFilter.messageReceived(session, message);
    }

    public boolean isMaskPassword() {
        return this.maskPassword;
    }

    public void setMaskPassword(boolean maskPassword) {
        this.maskPassword = maskPassword;
    }
}

