/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc;

import com.potix.doc.Printer;
import com.potix.doc.SourceCodeNode;
import com.potix.doc.Streams;
import com.potix.doc.WidgetArchiveFactory;
import com.potix.doc.archive.ZkClass;
import com.potix.doc.archive.langxml.LanguageContext;
import com.potix.doc.gwt.ZKGwtWidgetClassGenerator;
import com.potix.doc.jsdoc.ZKJavaScriptDocGenerator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public abstract class Generator {
    public static final String JAR_PATH;
    private static final String INS_VERBOSE = "--verbose";
    private static final String INS_TARGET = "-t";
    private static final String INS_GENERATE = "-g";
    private static final String INS_PURPOSE = "-p";
    private static final String INS_LOG = "-v";
    public static final String GEN_JSDOC = "jsdoc";
    public static final String GEN_GWT = "zkgwt";
    private static final String DESC = " \n--verbose show detail while generating.\n-t [path] set scan target path.\n-g [path] set generated result path.\n-p [jsdoc/zkgwt] set pupose of this generation.\n-v [DEBUG/INFO/WARN/ERROR/TRACE] set log4j's log level.\n";

    private static Properties getLogSettings(String level) {
        Properties logp = new Properties();
        try {
            String path = JAR_PATH + "/log4j.properties";
            if (new File(path).exists()) {
                logp.load(new FileInputStream(path));
            } else {
                logp.load(Generator.class.getClassLoader().getResourceAsStream("log4j.properties"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        String value = level + ", stdout";
        logp.setProperty("log4j.rootLogger", value);
        return logp;
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println("ZK Generator HELP:  \n--verbose show detail while generating.\n-t [path] set scan target path.\n-g [path] set generated result path.\n-p [jsdoc/zkgwt] set pupose of this generation.\n-v [DEBUG/INFO/WARN/ERROR/TRACE] set log4j's log level.\n");
            return;
        }
        Configuration config = null;
        try {
            config = new Configuration(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("You might have some configuration problem:  \n--verbose show detail while generating.\n-t [path] set scan target path.\n-g [path] set generated result path.\n-p [jsdoc/zkgwt] set pupose of this generation.\n-v [DEBUG/INFO/WARN/ERROR/TRACE] set log4j's log level.\n");
            System.exit(-1);
        }
        try {
            if (GEN_JSDOC.equals(config.getPurpose())) {
                System.out.println(">>> START ZK Javascript Document Generator...");
                new ZKJavaScriptDocGenerator().generate(config);
            } else if (GEN_GWT.equals(config.getPurpose())) {
                System.out.println(">>> START ZK GWT Widget Class Generator...");
                new ZKGwtWidgetClassGenerator().generate(config);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("ERROR: " + e.getMessage());
            System.exit(-1);
        }
    }

    private static void mkDir(String absPath) {
        File f = new File(absPath);
        if (f.exists() && f.isFile()) {
            throw new Error("mkdir:[" + f + "] is already exist but not a directory!!!");
        }
        if (!f.exists()) {
            f.mkdir();
        }
    }

    private static void assertExist(String absPath, String pre) {
        File f = new File(absPath);
        if (!f.exists()) {
            throw new Error(pre + " dir:[" + f + "] is not exist!!!");
        }
    }

    public void generate(Configuration config) throws Exception {
        System.out.println(">>> GENERATED PATH: " + config.getGeneratedPath());
        Printer.newInfoln(1);
        File rootFile = new File(config.getGeneratedPath());
        if (!rootFile.exists() || rootFile.isFile()) {
            throw new IllegalArgumentException(" no such Directory: " + config.getGeneratedPath());
        }
        LanguageContext langContext = this.initLanguageContext(config);
        SourceCodeNode rootNode = SourceCodeNode.newRootNode(config.getGeneratedPath());
        for (String targetPath : config.getTargetContextPaths()) {
            System.out.println(">>> SCAN PATH: " + targetPath);
            Generator.assertExist(targetPath, "target");
            WidgetArchiveFactory.getInstance().scanArchive(targetPath, langContext);
        }
        for (ZkClass zkClass : langContext.getZkClasses().values()) {
            this.generateClassSrc(zkClass, rootNode);
        }
        for (Map.Entry entry : langContext.getPackageHtmls().entrySet()) {
            this.generatePackageHtml((String)entry.getKey(), (String)entry.getValue(), rootNode);
        }
        Generator.writeSrcNode(rootNode);
    }

    protected LanguageContext initLanguageContext(Configuration config) {
        LanguageContext langContext = new LanguageContext(config);
        return langContext;
    }

    protected abstract SourceCodeNode generateClassSrc(ZkClass var1, SourceCodeNode var2);

    protected abstract SourceCodeNode generatePackageHtml(String var1, String var2, SourceCodeNode var3);

    protected abstract String getTranslatedPackage(ZkClass var1);

    protected static void writeSrcNode(SourceCodeNode node) throws IOException {
        Generator.createNodeWhetherExist(node);
        if (node.isFile()) {
            Generator.writeLeaf(node);
        } else {
            for (SourceCodeNode node1 : node.getChildren().values()) {
                Generator.writeSrcNode(node1);
            }
        }
    }

    protected SourceCodeNode recursiveCreateSrcNode(String path, int index, SourceCodeNode parent) {
        String[] segments = path.split("[.]");
        return Generator.recursiveCreateSrcNode(segments, index, parent);
    }

    protected SourceCodeNode recursiveCreateSrcNode(ZkClass aWidgetClass, int index, SourceCodeNode parent) {
        String[] segments = this.getTranslatedPackage(aWidgetClass).split("[.]");
        return Generator.recursiveCreateSrcNode(segments, index, parent);
    }

    private static SourceCodeNode recursiveCreateSrcNode(String[] segments, int index, SourceCodeNode parent) {
        if (index >= segments.length) {
            return parent;
        }
        SourceCodeNode node = parent.getChild(segments[index]);
        if (node == null) {
            node = new SourceCodeNode(segments[index], false);
            node.setParent(parent);
        }
        return Generator.recursiveCreateSrcNode(segments, ++index, node);
    }

    private static void writeLeaf(SourceCodeNode node) {
        if (!node.isFile()) {
            return;
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(node.getPath());
            ByteArrayInputStream in = new ByteArrayInputStream(node.getContent().getBytes());
            Streams.flush((InputStream)in, (OutputStream)fout, 2048);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private static File createNodeWhetherExist(SourceCodeNode node) throws IOException {
        File f = new File(node.getPath());
        if (!f.exists()) {
            if (!node.isFile()) {
                f.mkdir();
            } else {
                f.createNewFile();
            }
        }
        return f;
    }

    static {
        URL url = Generator.class.getProtectionDomain().getCodeSource().getLocation();
        String str = url.getFile();
        int endIndex = str.lastIndexOf("\\");
        if (endIndex < 0) {
            endIndex = str.lastIndexOf("/");
        }
        JAR_PATH = str.substring(0, endIndex);
        System.out.println(">>> Start ZK Generator at: " + JAR_PATH);
    }

    public static class Configuration {
        private boolean verbose = false;
        private String generatedPath = JAR_PATH + "/src_generated/";
        private String targetContextPaths = JAR_PATH + "/target/";
        private String logLevel = "WARN";
        private String purpose = "jsdoc";

        Configuration(String[] args) {
            for (int i = 0; i < args.length; ++i) {
                String key = args[i];
                if (Generator.INS_VERBOSE.equals(key)) {
                    this.verbose = true;
                    this.logLevel = "INFO";
                    continue;
                }
                String value = args[++i];
                if (key.equals(Generator.INS_TARGET)) {
                    this.targetContextPaths = value;
                    continue;
                }
                if (key.equals(Generator.INS_GENERATE)) {
                    this.generatedPath = value;
                    continue;
                }
                if (key.equals(Generator.INS_PURPOSE)) {
                    this.purpose = value;
                    continue;
                }
                if (key.equals(Generator.INS_LOG)) {
                    if (this.verbose) {
                        throw new IllegalArgumentException("dupplicate setting of verbose, log level  \n--verbose show detail while generating.\n-t [path] set scan target path.\n-g [path] set generated result path.\n-p [jsdoc/zkgwt] set pupose of this generation.\n-v [DEBUG/INFO/WARN/ERROR/TRACE] set log4j's log level.\n");
                    }
                    this.logLevel = value;
                    continue;
                }
                throw new IllegalArgumentException("unknown instruction: [" + key + "] " + Generator.DESC);
            }
            PropertyConfigurator.configure(Generator.getLogSettings(this.logLevel));
            Generator.mkDir(this.generatedPath);
        }

        public String[] getTargetContextPaths() {
            return this.targetContextPaths.split("[,]");
        }

        public String getGeneratedPath() {
            return this.generatedPath;
        }

        public String getLogLevel() {
            return this.logLevel;
        }

        public String getPurpose() {
            return this.purpose;
        }

        public boolean isVerbose() {
            return this.verbose;
        }
    }
}

