/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc;

import com.potix.doc.ILogMessage;
import com.potix.doc.Strings;
import com.potix.doc.archive.JsTextContext;
import com.potix.doc.js.TextChunk;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Printer {
    private static final Logger logger = Logger.getLogger(Printer.class);
    private static final String INDENT = "    ";

    public static void printChunks(Collection<TextChunk> arr) {
        if (logger.isTraceEnabled()) {
            for (TextChunk cmet : arr) {
                try {
                    logger.trace("comment: " + cmet.start() + "~" + cmet.end() + ">>");
                    logger.trace(cmet.getTextContent().substring(0, 15));
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void printJsTextContext(JsTextContext jsContext) {
        if (logger.isInfoEnabled()) {
            logger.debug("TEXT CONTENT PARSE RESULT IN: " + jsContext.getJsFilePath());
            Printer.recusivePrint(jsContext.getClassChks(), "|-");
        }
    }

    public static void recusivePrint(List<TextChunk> chks, String indent) {
        for (TextChunk chk : chks) {
            logger.debug(indent + "[" + chk.getType() + "] " + chk.start() + " ~ " + chk.end() + " : " + chk.getDesc());
            Printer.recusivePrint(chk.getSubTextChunks(), INDENT + indent);
        }
    }

    public static void newInfoln(int lines) {
        if (logger.isInfoEnabled()) {
            for (int i = lines; i >= 0; --i) {
                System.out.println();
            }
        }
    }

    public static void logError(Logger logger, ILogMessage message) {
        JsTextContext jsContext = message.getChunk().getJsTextContext();
        logger.error(jsContext.getJsFilePath() + " line: [" + Strings.startAtLine(jsContext.getTextContent(), message.getChunk().start()) + "] " + message.getMessage());
    }

    public static void logWarn(Logger logger, ILogMessage message) {
        JsTextContext jsContext = message.getChunk().getJsTextContext();
        logger.warn(jsContext.getJsFilePath() + " line: [" + Strings.startAtLine(jsContext.getTextContent(), message.getChunk().start()) + "] " + message.getMessage());
    }
}

