/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc;

import com.potix.doc.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCodeNode {
    private static final Logger logger = Logger.getLogger(SourceCodeNode.class);
    protected final String nodeName;
    protected final Map<String, SourceCodeNode> children;
    protected final boolean leaf;
    protected String content;
    private SourceCodeNode parent;
    static final byte[] buffer = new byte[4096];

    public SourceCodeNode(String nodeName, boolean isLeaf) {
        this.nodeName = nodeName;
        this.leaf = isLeaf;
        this.children = isLeaf ? null : new LinkedHashMap();
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isFile() {
        return this.leaf;
    }

    public SourceCodeNode getParent() {
        return this.parent;
    }

    public void setParent(SourceCodeNode parent) {
        if (this.parent == parent) {
            return;
        }
        if (parent.isFile()) {
            throw new IllegalArgumentException("You can't assign child to a Leaf Node");
        }
        if (this.parent != null) {
            this.parent.getChildren().remove(this.nodeName);
        }
        parent.getChildren().put(this.nodeName, this);
        this.parent = parent;
    }

    public SourceCodeNode getChild(String nodeName) {
        return this.children.get(nodeName);
    }

    public Map<String, SourceCodeNode> getChildren() {
        return this.children;
    }

    public String getPath() {
        return this.parent.getPath() + this.getNodeName() + "/";
    }

    public Root getRoot() {
        return this.parent.getRoot();
    }

    public void save() {
    }

    public static SourceCodeNode newRootNode(final String rootPath) {
        logger.trace("create new RootNode ");
        return new SourceCodeNode("", false){
            Root root;
            {
                super(x0, x1);
                this.root = new Root(rootPath);
            }

            public String getPath() {
                return this.root.absolutePath;
            }

            public Root getRoot() {
                return this.root;
            }
        };
    }

    public static SourceCodeNode load(String rootPath) throws IOException {
        File rootFile = new File(rootPath);
        if (!rootFile.exists()) {
            return null;
        }
        if (rootFile.isFile()) {
            throw new IllegalArgumentException(" no such Directory: " + rootPath);
        }
        SourceCodeNode node = SourceCodeNode.newRootNode(rootPath);
        logger.info("Load File tree as SrcNode Tree: " + rootFile);
        SourceCodeNode.recusiveFileNode(rootFile, node);
        return node;
    }

    private static void recusiveFileNode(File parentFile, SourceCodeNode parentNode) throws IOException {
        logger.info("recusiveFileNode: " + parentFile.getAbsolutePath());
        for (File file : parentFile.listFiles()) {
            SourceCodeNode src = new SourceCodeNode(file.getName(), file.isFile());
            src.setParent(parentNode);
            if (src.isFile()) {
                src.setContent(SourceCodeNode.readText(file));
                continue;
            }
            SourceCodeNode.recusiveFileNode(file, src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readText(File file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            Streams.flush((InputStream)fin, (OutputStream)out, buffer);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        return new String(out.toByteArray());
    }

    public static class Root {
        public String absolutePath;

        public Root(String path) {
            this.absolutePath = path;
        }
    }
}

