/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Streams {
    public static void flush(InputStream in, OutputStream out, int chunkSize) throws IOException {
        byte[] b = new byte[chunkSize];
        Streams.flush(in, out, b);
    }

    public static void flush(InputStream in, OutputStream out, byte[] chunk) throws IOException {
        int readLen = -1;
        while ((readLen = in.read(chunk)) != -1) {
            out.write(chunk, 0, readLen);
        }
        out.flush();
    }

    public static String readTextContent(File file, int chunkSize) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            Streams.flush((InputStream)fin, (OutputStream)bout, chunkSize);
            String string = new String(bout.toByteArray(), "UTF-8");
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String readTextContent(String path, int chunkSize) {
        return Streams.readTextContent(new File(path), chunkSize);
    }
}

