/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Strings {
    static char[] ascii0 = new char[]{' ', '.', '/', '-', '_', '?', '`', '~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '+', '=', '|', '\\', '[', ']', '{', '}', ';', ':', '\'', '\"', '<', '>', ','};
    static char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String char2String(char[] chars) {
        if (chars == null) {
            return "";
        }
        return new String(chars);
    }

    public static String replace(String srcStr, String fromStr, String toStr) {
        if (srcStr == null) {
            return null;
        }
        String normalString = "";
        int length = srcStr.length();
        int position = 0;
        int previous = 0;
        int spacer = fromStr.length();
        while (position + spacer - 1 < length && srcStr.indexOf(fromStr, position) > -1) {
            position = srcStr.indexOf(fromStr, previous);
            normalString = normalString + srcStr.substring(previous, position) + toStr;
            previous = position += spacer;
        }
        normalString = normalString + srcStr.substring(position, srcStr.length());
        return normalString;
    }

    public static void append(StringBuffer sb, Object ... strings) {
        for (Object obj : strings) {
            sb.append(obj);
        }
    }

    public static void appendEach(StringBuffer sb, Object[] strings) {
        for (Object obj : strings) {
            sb.append(obj);
        }
    }

    public static void appendln(StringBuffer sb, Object ... strings) {
        for (Object obj : strings) {
            sb.append(obj);
        }
        sb.append("\n");
    }

    public static void appendlnEach(StringBuffer sb, Object[] strings) {
        for (Object obj : strings) {
            sb.append(obj);
        }
        sb.append("\n");
    }

    public static void appendln(StringBuffer sb) {
        sb.append("\n");
    }

    public static StringBuffer append(Object ... strings) {
        StringBuffer sb = new StringBuffer();
        for (Object obj : strings) {
            sb.append(obj);
        }
        return sb;
    }

    public static boolean equals(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return false;
    }

    public static String escape(String src, char[] escapes) {
        return Strings.escape(src, escapes, false, '@');
    }

    public static String escape(String src, char[] escapes, boolean asciionly, char escaper) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        block0: for (int i = 0; i < src.length(); ++i) {
            int j;
            char ch = src.charAt(i);
            if (ch == escaper) {
                tmp.append(escaper);
                tmp.append(Strings.toHex(ch, 4));
                continue;
            }
            for (j = 0; j < escapes.length; ++j) {
                if (ch != escapes[j]) continue;
                tmp.append(escaper);
                tmp.append(Strings.toHex(ch, 4));
                continue block0;
            }
            if (!(!Character.isDigit(ch) && !Character.isLetter(ch) || ch > '\u007f' && asciionly)) {
                tmp.append(ch);
                continue;
            }
            for (j = 0; j < ascii0.length; ++j) {
                if (ch != ascii0[j]) continue;
                tmp.append(ch);
                continue block0;
            }
            tmp.append(escaper);
            tmp.append(Strings.toHex(ch, 4));
        }
        return tmp.toString();
    }

    static char[] toHex(char ch, int length) {
        char[] val = new char[length];
        int x = ch;
        for (int i = val.length - 1; i >= 0; --i) {
            val[i] = HEX[x & 0xF];
            x >>= 4;
        }
        return val;
    }

    public static String unescape(String src, char[] escapes) {
        return Strings.unescape(src, escapes, '@');
    }

    public static String unescape(String src, char[] escapes, char escaper) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf(escaper, lastPos);
            if (pos == lastPos) {
                char ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 5), 16);
                tmp.append(ch);
                lastPos = pos + 5;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static boolean hasValue(String str) {
        return str != null && !str.equals("");
    }

    public static String remove(String pattern, String str) {
        String[] arr = Strings.split(str, pattern, false);
        StringBuffer sb = new StringBuffer();
        for (String s : arr) {
            Strings.append(sb, s);
        }
        return sb.toString();
    }

    public static String[] split(String exp, String pattern, boolean returnPattern) {
        String t;
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(exp);
        int start = 0;
        int end = 0;
        int lend = 0;
        while (m.find()) {
            start = m.start();
            end = m.end();
            if (lend != start) {
                t = exp.substring(lend, start);
                result.add(t);
            }
            if (returnPattern) {
                t = exp.substring(start, end);
                result.add(t);
            }
            lend = end;
        }
        if (lend < exp.length()) {
            t = exp.substring(lend, exp.length());
            result.add(t);
        }
        return result.toArray(new String[result.size()]);
    }

    public static int startAtLine(String textBody, int offset) {
        int lines = 1;
        char[] arr = textBody.toCharArray();
        for (int i = offset; i >= 0; --i) {
            if (arr[i] != '\n') continue;
            ++lines;
        }
        return lines;
    }
}

