/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc;

import com.potix.doc.Streams;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLHelper {
    private static final Logger logger = Logger.getLogger(XMLHelper.class.getName());
    private XPathFactory xPathFactory = XPathFactory.newInstance();
    String xml;
    LinkedHashMap<String, WeakReference<XPathExpression>> pathCache = new LinkedHashMap();

    public XMLHelper(String xml) {
        this.xml = xml;
    }

    public XMLHelper(InputStream is) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Streams.flush(is, (OutputStream)bos, 1024);
            this.xml = new String(bos.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    public XMLHelper(Reader reader) {
        try {
            int r;
            StringBuffer sb = new StringBuffer();
            char[] buf = new char[1024];
            while ((r = reader.read(buf)) != -1) {
                sb.append(buf, 0, r);
            }
            this.xml = sb.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    private InputSource getSource() {
        return new InputSource(new StringReader(this.xml));
    }

    public static String getTextValue(Node n) {
        if (n == null) {
            return "";
        }
        return n.getTextContent();
    }

    public static String getAttributeValue(Node node, String name) {
        NamedNodeMap nnm = node.getAttributes();
        if (nnm == null) {
            return null;
        }
        Node n = nnm.getNamedItem(name);
        if (n != null) {
            return n.getNodeValue();
        }
        return "";
    }

    public static Properties getAttributes(Node node) {
        Properties props = new Properties();
        NamedNodeMap nnm = node.getAttributes();
        int index = nnm.getLength();
        if (nnm == null) {
            return props;
        }
        for (int i = 0; i < index; ++i) {
            Node temp = nnm.item(i);
            props.setProperty(temp.getNodeName(), temp.getNodeValue());
        }
        return props;
    }

    private XPathExpression createXPath(String query) throws XPathExpressionException {
        WeakReference<XPathExpression> ref = this.pathCache.get(query);
        XPathExpression path = null;
        if (ref != null) {
            path = (XPathExpression)ref.get();
        }
        if (path != null) {
            return path;
        }
        path = this.xPathFactory.newXPath().compile(query);
        this.pathCache.put(query, new WeakReference<XPathExpression>(path));
        return path;
    }

    public String getNodeContentValue(String queryStr) {
        try {
            Node node = (Node)this.createXPath(queryStr).evaluate(this.getSource(), XPathConstants.NODE);
            if (node != null) {
                return XMLHelper.getTextValue(node);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return null;
    }

    public String getNodeContentValue(Node parent, String queryStr) {
        try {
            Node node = (Node)this.createXPath(queryStr).evaluate(parent, XPathConstants.NODE);
            if (node != null) {
                return XMLHelper.getTextValue(node);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return null;
    }

    public NodeList getNodeList(String queryStr) {
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)this.createXPath(queryStr).evaluate(this.getSource(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            logger.error("xml:" + this.xml + ":query:" + queryStr, e);
        }
        return nodeList;
    }

    public NodeList getNodeList(Node node, String queryStr) {
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)this.createXPath(queryStr).evaluate(node, XPathConstants.NODESET);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return nodeList;
    }
}

