/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.archive;

import com.potix.doc.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comment {
    private static final Pattern CLASS_Ptn = Pattern.compile("\\@class");
    private static final String DISABLE = "\\@disable\\([\\s]*([\\w]+)[\\s]*\\)";
    private static final Pattern DISABLE_Ptn = Pattern.compile("\\@disable\\([\\s]*([\\w]+)[\\s]*\\)");
    private static final Pattern RETURN_Ptn = Pattern.compile("[\\r\\n][\\s]*\\*[\\s]*\\@return[\\s]*([\\w.\\[\\]]+)");
    private static final Pattern PARAM_Ptn = Pattern.compile("[\\r\\n][\\s]*\\*[\\s]*\\@param[\\s]*([\\w.\\[\\]]+[\\s][\\w.]+)");
    private static final Pattern FIELD_TYPE_Ptn = Pattern.compile("[\\r\\n][\\s]*\\*[\\s]*\\@type[\\s]*([\\w.\\[\\]]+)");
    private String commentStr;
    private Set<String> disables = new HashSet<String>();
    private List<String> paramDeclarations;
    private String fieldType;
    private String returnType;
    public static final Pattern IMPORT_Ptn = Pattern.compile("[\\s]*\\*[\\s]*\\@(import[\\s][\\w.\\*]+[\\s]*)[\\;]?[\\r\\n]");

    public Comment(String commentStr) {
        this.commentStr = commentStr;
        Matcher match = DISABLE_Ptn.matcher(commentStr);
        while (match.find()) {
            String type = match.group(1);
            this.disables.add(type);
        }
    }

    public boolean shouldDisable(String type) {
        if (type == null || type.isEmpty()) {
            return false;
        }
        return this.disables.contains(type);
    }

    public boolean isClass() {
        Matcher match = CLASS_Ptn.matcher(this.commentStr);
        return match.find();
    }

    public boolean isGetter() {
        return !this.isSetter();
    }

    public boolean isSetter() {
        Matcher match = PARAM_Ptn.matcher(this.commentStr);
        return match.find();
    }

    public List<String> getParamDeclarations() {
        if (this.paramDeclarations == null) {
            this.paramDeclarations = Comment.getMatchedArgs(this.commentStr, PARAM_Ptn);
        }
        return this.paramDeclarations;
    }

    public boolean isField() {
        Matcher match = FIELD_TYPE_Ptn.matcher(this.commentStr);
        return match.find();
    }

    public boolean isFunction() {
        return !this.isField();
    }

    public String getFieldType() {
        if (this.fieldType == null) {
            List<String> fieldTypes = Comment.getMatchedArgs(this.commentStr, FIELD_TYPE_Ptn);
            this.fieldType = fieldTypes.size() <= 0 ? null : fieldTypes.get(0);
        }
        return this.fieldType;
    }

    public String getReturnType() {
        if (this.returnType == null) {
            List<String> arr = Comment.getMatchedArgs(this.commentStr, RETURN_Ptn);
            this.returnType = arr.size() <= 0 ? null : arr.get(0);
        }
        return this.returnType;
    }

    private static List<String> getMatchedArgs(String text, Pattern ptn) {
        ArrayList<String> arr = new ArrayList<String>();
        Matcher match = ptn.matcher(text);
        while (match.find()) {
            String type = match.group(1);
            arr.add(type);
        }
        return arr;
    }

    public String toString() {
        return this.commentStr;
    }

    public String toClassString() {
        String str = Strings.remove(DISABLE, Strings.remove("@class[\\s]+[\\w.]+", this.commentStr));
        Matcher match = IMPORT_Ptn.matcher(str);
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (match.find()) {
            int end;
            int start = match.start();
            Strings.appendln(sb, str.substring(index, start));
            index = end = match.end();
        }
        sb.append(str.substring(index));
        return sb.toString();
    }

    public String toMethodString() {
        String temp = Strings.remove(DISABLE, this.commentStr);
        Matcher match = PARAM_Ptn.matcher(temp);
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (match.find()) {
            int end;
            int start = match.start(1);
            sb.append(temp.substring(index, start));
            index = end = temp.indexOf(" ", start);
        }
        sb.append(temp.substring(index));
        return sb.toString();
    }
}

