/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.archive;

import com.potix.doc.ILogMessage;
import com.potix.doc.Printer;
import com.potix.doc.archive.Comment;
import com.potix.doc.archive.Type;
import com.potix.doc.archive.langxml.LanguageContext;
import com.potix.doc.js.TextChunk;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Field {
    private static final Logger logger = Logger.getLogger(Field.class);
    private Comment comment;
    private Type fieldType;
    private String accessModifer = "protected";
    private String fieldName;
    private boolean _static;
    private final TextChunk fromChk;
    private final LanguageContext langContext;
    private static final Pattern FIELD_NAME_Ptn = Pattern.compile("[\\r\\n][\\s]*(//)?+[\\s]*([\\w\\$]+)[\\s]*:");

    public Field(TextChunk chunk, LanguageContext langContext) {
        this.fromChk = chunk;
        this.langContext = langContext;
    }

    public TextChunk getFromChk() {
        return this.fromChk;
    }

    public void setStatic(boolean var) {
        this._static = var;
    }

    public boolean isStatic() {
        return this._static;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public Type getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = this.langContext.getTypeFactory().getInstance(fieldType);
    }

    public String getAccessModifer() {
        if (this.accessModifer == null || "null".equals(this.accessModifer)) {
            throw new IllegalStateException("accessModifer can't be Null!");
        }
        return this.accessModifer;
    }

    public void setAccessModifer(String accessModifer) {
        this.accessModifer = accessModifer;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public static Field initField(final TextChunk chunk, boolean isStatic, LanguageContext langContext) {
        String text = chunk.getTextContent();
        Field field = new Field(chunk, langContext);
        field.setStatic(isStatic);
        if (text.endsWith("_")) {
            field.setAccessModifer("protected");
        } else if (text.startsWith("_")) {
            field.setAccessModifer("private");
            Printer.logWarn(logger, new ILogMessage(){

                public String getMessage() {
                    return "is a private commented field!";
                }

                public TextChunk getChunk() {
                    return chunk;
                }
            });
        } else {
            field.setAccessModifer("public");
        }
        Comment comment = null;
        for (final TextChunk chk : chunk.findByType("Comment")) {
            if (comment == null) {
                comment = new Comment(chk.getTextContent());
                field.setComment(comment);
                continue;
            }
            Printer.logWarn(logger, new ILogMessage(){

                public String getMessage() {
                    return "Duplicate Comment of Field Declaration.";
                }

                public TextChunk getChunk() {
                    return chk;
                }
            });
        }
        if (comment == null) {
            Printer.logWarn(logger, new ILogMessage(){

                public String getMessage() {
                    return " There's no Comment for this field, can't define field Type";
                }

                public TextChunk getChunk() {
                    return chunk;
                }
            });
            field.setFieldType("NoCommentToDefineType");
        } else {
            field.setFieldType(field.getComment().getFieldType());
        }
        field.setFieldName(Field.parseFieldName(text));
        return field;
    }

    private static String parseFieldName(String text) {
        Matcher match = FIELD_NAME_Ptn.matcher(text);
        if (match.find()) {
            String str = match.group(2);
            return str;
        }
        return "NO_SUCH_FIELD_NAME_IN_TEXT/[[*" + text + "]]*/";
    }
}

