/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.archive;

import com.potix.doc.Printer;
import com.potix.doc.Streams;
import com.potix.doc.archive.JsTextContext;
import com.potix.doc.archive.langxml.LanguageContext;
import com.potix.doc.js.JsTextContextParser;
import com.potix.doc.pack.IWidgetResourceArchive;
import com.potix.doc.pack.WidgetPackageDiscripter;
import java.io.File;
import java.io.FilenameFilter;
import org.apache.log4j.Logger;

public class FolderWidgetResourceArchive
implements IWidgetResourceArchive {
    private static final Logger logger = Logger.getLogger(FolderWidgetResourceArchive.class);
    private File root;
    private LanguageContext language;
    private static final int KB = 1024;
    private static final FilenameFilter wpdFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.equals("zk.wpd");
        }
    };

    public boolean parseArchive(File file, LanguageContext langContext) {
        if (!file.exists() || file.isFile()) {
            return false;
        }
        this.root = file;
        this.language = langContext;
        FolderWidgetResourceArchive.recursiveFindWpds(this.language, this.root);
        return true;
    }

    private static void recursiveFindWpds(LanguageContext lang, File dir) {
        if (FolderWidgetResourceArchive.isSVN(dir)) {
            return;
        }
        File[] zkwpds = dir.listFiles(wpdFilter);
        if (zkwpds != null && zkwpds.length >= 1) {
            WidgetPackageDiscripter wpd = new WidgetPackageDiscripter(Streams.readTextContent(zkwpds[0], 3072), zkwpds[0].getAbsolutePath());
            lang.getWPDs().put(wpd.getPackage(), wpd);
            FolderWidgetResourceArchive.scanWPD(wpd, lang);
        }
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) continue;
            FolderWidgetResourceArchive.recursiveFindWpds(lang, f);
        }
    }

    private static boolean isSVN(File file) {
        return ".svn".equals(file.getName().toLowerCase());
    }

    private static void scanWPD(WidgetPackageDiscripter wpd, LanguageContext language) {
        Printer.newInfoln(1);
        logger.info("WidgetPackageDiscripter is: " + wpd.getAbsolutePath());
        for (String wsFileName : wpd.getWidgetJsFiles()) {
            String wjsPath = wpd.getAbsolutePackageDir() + File.separator + wsFileName;
            logger.info("WidgetScript Path: " + wjsPath);
            JsTextContext wc = new JsTextContext(language, wpd, Streams.readTextContent(wjsPath, 3072), wjsPath);
            JsTextContextParser.parseJsText(wc);
            Printer.printJsTextContext(wc);
            Printer.newInfoln(1);
        }
    }

    public LanguageContext getLanguageContext() {
        return this.language;
    }
}

