/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.archive;

import com.potix.doc.ILogMessage;
import com.potix.doc.Printer;
import com.potix.doc.Strings;
import com.potix.doc.archive.Comment;
import com.potix.doc.archive.JsTextContext;
import com.potix.doc.archive.Type;
import com.potix.doc.archive.langxml.LanguageContext;
import com.potix.doc.js.TextChunk;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Method {
    private static final Logger logger = Logger.getLogger(Method.class);
    private Comment comment;
    private String accessModifer = "public";
    private String methodSignature;
    private Type methodReturnType;
    private List<Argument> methodParameters = new LinkedList<Argument>();
    private boolean _static;
    private final TextChunk fromChk;
    private final LanguageContext langContext;
    private static final Pattern FUNC_Ptn = Pattern.compile("[a-zA-Z\\$][\\$\\w]*");
    private static final Pattern DEFINE_FIELD_Ptn = Pattern.compile("[\\r\\n][\\s]*([\\$\\w]+)[\\s]*:");

    public Method(TextChunk chunk, LanguageContext langContext) {
        this.fromChk = chunk;
        this.langContext = langContext;
    }

    public TextChunk getFromChk() {
        return this.fromChk;
    }

    public String getAccessModifer() {
        if (this.methodSignature.startsWith("_")) {
            return "private";
        }
        if (this.methodSignature.endsWith("_")) {
            return "protected";
        }
        return this.accessModifer;
    }

    public void setAccessModifer(String accessModifer) {
        this.accessModifer = accessModifer;
    }

    public boolean isStatic() {
        return this._static;
    }

    public void setStatic(boolean isStatic) {
        this._static = isStatic;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public String getSignature() {
        return this.methodSignature;
    }

    public void setSignature(String methodSignature) {
        this.methodSignature = methodSignature;
    }

    public Type getReturnType() {
        return this.methodReturnType;
    }

    public void setReturnType(Type methodReturnType) {
        this.methodReturnType = methodReturnType;
    }

    public List<Argument> getArguments() {
        return this.methodParameters;
    }

    public void setMethodArguments(List<String> methodParameters) {
        for (String str : methodParameters) {
            String[] arr = str.split("[\\s]");
            String type = arr[0];
            String argName = Method.toValidName(arr[1]);
            this.methodParameters.add(new Argument(type, argName, this.langContext));
        }
    }

    private static String toValidName(String varName) {
        String[] arr = varName.split("[^\\w_$]");
        StringBuffer sb = new StringBuffer();
        for (String str : arr) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static void initMethodOverloads(List<Method> widgetMethods, final TextChunk methodChk, boolean isStatic, LanguageContext langContext) {
        if (!"Func".equals(methodChk.getType())) {
            return;
        }
        Matcher match = FUNC_Ptn.matcher(methodChk.getTextContent());
        String signature = "";
        if (!match.find()) {
            logger.warn("this Method's format is not valid: " + methodChk);
            return;
        }
        signature = match.group();
        List<TextChunk> comments = methodChk.findByType("Comment");
        for (TextChunk commentChk : comments) {
            Method method = new Method(commentChk, langContext);
            Comment comment = new Comment(commentChk.getTextContent());
            if (comment.shouldDisable(langContext.getMode())) {
                logger.info("[IGNORE] method: " + method.getSignature());
                continue;
            }
            if (signature.endsWith("_")) {
                method.setAccessModifer("protected");
            } else if (signature.startsWith("_")) {
                method.setAccessModifer("private");
                Printer.logWarn(logger, new ILogMessage(){

                    public String getMessage() {
                        return "is a private commented field!";
                    }

                    public TextChunk getChunk() {
                        return methodChk;
                    }
                });
            } else {
                method.setAccessModifer("public");
            }
            method.setStatic(isStatic);
            method.setMethodArguments(comment.getParamDeclarations());
            Type type = langContext.getTypeFactory().getInstance(comment.getReturnType() == null ? "void" : comment.getReturnType());
            method.setReturnType(type);
            method.setSignature(signature);
            method.setComment(comment);
            widgetMethods.add(method);
        }
    }

    public static void initGetterSetters(List<Method> widgetMethods, TextChunk defineChk, LanguageContext langContext) {
        if (!"DefineField".equals(defineChk.getType())) {
            return;
        }
        Matcher match = DEFINE_FIELD_Ptn.matcher(defineChk.getTextContent());
        String signature = "";
        if (!match.find()) {
            logger.error("this Method's format is not valid:  offset:" + defineChk.start() + " end:" + defineChk.end() + " text:" + defineChk.getTextContent());
            return;
        }
        signature = match.group(1);
        for (TextChunk chk : defineChk.getSubTextChunks()) {
            if ("Comment".equals(chk.getType())) {
                Comment comment = new Comment(chk.getTextContent());
                Method method = new Method(chk, langContext);
                if (comment.shouldDisable(langContext.getMode())) {
                    logger.info("[IGNORE] method: " + method.getSignature());
                    continue;
                }
                String property = Method.firstCharUpperCase(signature);
                if (comment.isSetter()) {
                    property = "set" + property;
                } else if (comment.isGetter()) {
                    property = "boolean".equals(comment.getReturnType()) ? "is" + property : "get" + property;
                } else {
                    JsTextContext context = defineChk.getJsTextContext();
                    logger.warn(context.getJsFilePath() + " line:" + Strings.startAtLine(context.getTextContent(), chk.start()) + " neither getter nor setter, do nothing.");
                    return;
                }
                method.setMethodArguments(comment.getParamDeclarations());
                Type type = langContext.getTypeFactory().getInstance(comment.getReturnType() == null ? "void" : comment.getReturnType());
                method.setReturnType(type);
                method.setSignature(property);
                method.setComment(comment);
                widgetMethods.add(method);
                continue;
            }
            logger.warn("what is this chunk for as a Method content? type:" + chk.getType() + " text:" + chk.getTextContent());
        }
    }

    private static String firstCharUpperCase(String str) {
        if (str.length() <= 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static class Argument {
        final Type type;
        final String argName;
        private final LanguageContext langContext;

        public Argument(String type, String argName, LanguageContext langContext) {
            this.argName = argName;
            this.langContext = langContext;
            this.type = this.langContext.getTypeFactory().getInstance(type);
        }

        public Type getType() {
            return this.type;
        }

        public String getArgName() {
            return this.argName;
        }

        public String toString() {
            return this.type + " " + this.argName;
        }
    }
}

