/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.archive;

import com.potix.doc.Strings;
import com.potix.doc.archive.Comment;
import com.potix.doc.archive.Field;
import com.potix.doc.archive.JsTextContext;
import com.potix.doc.archive.Method;
import com.potix.doc.archive.Type;
import com.potix.doc.archive.langxml.LanguageContext;
import com.potix.doc.js.TextChunk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZkClass {
    private static final Logger logger = Logger.getLogger(ZkClass.class);
    private final String className;
    private final String classPackage;
    private Type superClass;
    private final List<Method> methods = new LinkedList<Method>();
    private final List<Field> fields = new LinkedList<Field>();
    private final Set<TextChunk> chks = new HashSet<TextChunk>();
    private List<Comment> comments = new LinkedList<Comment>();
    private final LanguageContext langContext;

    public ZkClass(String className, String classPackage, LanguageContext langContext) {
        if (className == null || classPackage == null) {
            throw new IllegalArgumentException("className, classPackage can't be NULL: " + className + ", " + classPackage);
        }
        this.className = className;
        this.classPackage = classPackage;
        this.langContext = langContext;
        logger.info("CREATE NEW CLASS: " + classPackage + "." + className);
    }

    public boolean shouldDisable(String key) {
        for (Comment cmt : this.comments) {
            if (!cmt.shouldDisable(key)) continue;
            return true;
        }
        return false;
    }

    public LanguageContext getLangContext() {
        return this.langContext;
    }

    public List<String> getSrcPaths() {
        ArrayList<String> arr = new ArrayList<String>();
        for (TextChunk chk : this.chks) {
            JsTextContext ctx = chk.getJsTextContext();
            int line = Strings.startAtLine(chk.getJsTextContext().getTextContent(), chk.start());
            arr.add(ctx.getJsFilePath() + "[" + line + "]");
        }
        return arr;
    }

    public void loadClassChunk(TextChunk wClassChk, boolean hasPrototype) {
        for (TextChunk chunk : wClassChk.getSubTextChunks()) {
            if ("Comment".equals(chunk.getType())) {
                this.comments.add(new Comment(chunk.getTextContent()));
                this.chks.add(chunk);
                continue;
            }
            if ("Func".equals(chunk.getType())) {
                Method.initMethodOverloads(this.methods, chunk, !hasPrototype, this.langContext);
                continue;
            }
            if ("Define".equals(chunk.getType())) {
                for (TextChunk chk : chunk.getSubTextChunks()) {
                    Method.initGetterSetters(this.methods, chk, this.langContext);
                }
                continue;
            }
            if (!"Field".equals(chunk.getType())) continue;
            this.fields.add(Field.initField(chunk, !hasPrototype, this.langContext));
        }
    }

    public void addComment(Comment comment2) {
        this.comments.add(comment2);
    }

    public void addComment(List<Comment> cmts) {
        this.comments.addAll(cmts);
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public void setSuperClassType(String superClass) {
        this.superClass = this.langContext.getTypeFactory().getInstance(superClass);
    }

    public Type getSuperClass() {
        return this.superClass;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackage() {
        return this.classPackage;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public Comment getClassComment() {
        Comment comment = null;
        for (Comment com : this.comments) {
            if (comment == null) {
                comment = com;
            }
            if (!com.isClass()) continue;
            return com;
        }
        return comment;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Collection<String> getImports() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Comment commt : this.comments) {
            Matcher match = Comment.IMPORT_Ptn.matcher(commt.toString());
            while (match.find()) {
                String import_ = match.group(1).trim();
                if ((import_ = import_.substring(6).trim()).endsWith(";")) {
                    import_ = import_.substring(0, import_.length() - 1);
                }
                if (set.contains(import_)) continue;
                set.add(import_);
            }
        }
        return set;
    }

    public String getFullClassName() {
        return this.getPackage() + "." + this.getClassName();
    }
}

