/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.archive.langxml;

import com.potix.doc.Generator;
import com.potix.doc.archive.Type;
import com.potix.doc.archive.ZkClass;
import com.potix.doc.archive.langxml.TypeFactory;
import com.potix.doc.pack.WidgetPackageDiscripter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageContext {
    private static final Logger logger = Logger.getLogger(LanguageContext.class);
    private String name;
    private String languageName;
    private final Map<String, ZkClass> zkClasses = new LinkedHashMap<String, ZkClass>();
    private final Map<String, String> zkPackageHtmls = new LinkedHashMap<String, String>();
    private final Map<String, WidgetPackageDiscripter> wpds = new LinkedHashMap<String, WidgetPackageDiscripter>();
    private TypeFactory typeFactory = new TypeFactory(){

        public Type getInstance(final String typeStr) {
            return new Type(){

                public boolean isEmpty() {
                    return typeStr == null || typeStr.isEmpty();
                }

                public String getTypeName() {
                    return typeStr;
                }

                public String getOriginal() {
                    return typeStr;
                }

                public String toString() {
                    return typeStr;
                }
            };
        }
    };
    private final Generator.Configuration config;

    public LanguageContext(Generator.Configuration config) {
        this.config = config;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void setTypeFactory(TypeFactory typeFactory) {
        if (typeFactory == null) {
            throw new IllegalArgumentException("typeFactory can't be null!");
        }
        this.typeFactory = typeFactory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public Map<String, String> getPackageHtmls() {
        return this.zkPackageHtmls;
    }

    public void addPackageHtml(String packagePath, String content) {
        this.zkPackageHtmls.put(packagePath, content);
    }

    public Map<String, ZkClass> getZkClasses() {
        return this.zkClasses;
    }

    public ZkClass getZkClass(String clazz) {
        return this.zkClasses.get(clazz);
    }

    public void appendClass(ZkClass zkClass) {
        String str = zkClass.getFullClassName();
        ZkClass zc = this.zkClasses.get(str);
        if (zc == null) {
            this.zkClasses.put(zkClass.getFullClassName(), zkClass);
        } else {
            zc.addComment(zkClass.getComments());
            zc.getFields().addAll(zkClass.getFields());
            zc.getMethods().addAll(zkClass.getMethods());
        }
    }

    public Map<String, WidgetPackageDiscripter> getWPDs() {
        return this.wpds;
    }

    public String getMode() {
        return this.config.getPurpose();
    }
}

