/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.gwt;

import com.potix.doc.Strings;
import com.potix.doc.archive.Method;
import com.potix.doc.archive.Type;
import com.potix.doc.js.TextChunk;

public class MethodGenHelper {
    private StringBuffer sb;
    private String preffix;
    private Method method;

    public MethodGenHelper(StringBuffer sb, String preffix, Method method) {
        this.sb = sb;
        this.preffix = preffix;
        this.method = method;
    }

    public void generate() {
        Type gwtReturnType = this.method.getReturnType();
        String accessModifier = this.method.getAccessModifer();
        if (!"public".equalsIgnoreCase(accessModifier) || this.method.isStatic()) {
            return;
        }
        String mSignature = this.method.getSignature();
        this.writeln(new Object[0]);
        this.writeln("public native ", gwtReturnType, " ", mSignature, "(", MethodGenHelper.getArgs(this.method), ")/*-{");
        this.writeContentln("var widget = this.@org.zkoss.gwt.client.zk.Widget::getZkWidget()();");
        this.writeContentln("void".equals(gwtReturnType.getTypeName()) ? "" : "return ", "widget.", this.method.getSignature(), "(", MethodGenHelper.getParams(this.method), ");");
        TextChunk chk = this.method.getFromChk();
        String filePath = chk.getJsTextContext().getJsFilePath().replaceAll("[\\\\]", "/").replaceAll("//", "/");
        int line = Strings.startAtLine(chk.getJsTextContext().getTextContent(), chk.start());
        this.writeln("}-*/; //", filePath, " line:[", line, "]");
    }

    private void writeln(Object ... objs) {
        this.sb.append(this.preffix);
        for (Object obj : objs) {
            this.sb.append(obj);
        }
        this.sb.append("\n");
    }

    private void writeContentln(Object ... objs) {
        this.sb.append(this.preffix).append("\t");
        for (Object obj : objs) {
            this.sb.append(obj);
        }
        this.sb.append("\n");
    }

    private static String getParams(Method method) {
        StringBuffer sb = new StringBuffer();
        for (Method.Argument parm : method.getArguments()) {
            Strings.append(sb, parm.getArgName(), ", ");
        }
        String params = sb.toString();
        if (params.endsWith(", ")) {
            params = params.substring(0, params.length() - 2);
        }
        return params;
    }

    private static String getArgs(Method method) {
        StringBuffer sb = new StringBuffer();
        for (Method.Argument parm : method.getArguments()) {
            Type type = parm.getType();
            Strings.append(sb, type, " ", parm.getArgName(), ", ");
        }
        String params = sb.toString();
        if (params.endsWith(", ")) {
            params = params.substring(0, params.length() - 2);
        }
        return params;
    }
}

