/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.gwt;

import com.potix.doc.Generator;
import com.potix.doc.SourceCodeNode;
import com.potix.doc.Strings;
import com.potix.doc.archive.Method;
import com.potix.doc.archive.Type;
import com.potix.doc.archive.ZkClass;
import com.potix.doc.archive.langxml.LanguageContext;
import com.potix.doc.gwt.MethodGenHelper;
import com.potix.doc.gwt.ZkGwtTypeFactory;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZKGwtWidgetClassGenerator
extends Generator {
    private static final Logger logger = Logger.getLogger(ZKGwtWidgetClassGenerator.class);
    private int i;

    @Override
    protected LanguageContext initLanguageContext(Generator.Configuration config) {
        LanguageContext langContext = super.initLanguageContext(config);
        langContext.setTypeFactory(new ZkGwtTypeFactory(langContext));
        return langContext;
    }

    @Override
    protected SourceCodeNode generateClassSrc(ZkClass wdClz, SourceCodeNode root) {
        String zFullQName = wdClz.getFullClassName();
        if ("zul.Widget".equals(zFullQName) || wdClz.shouldDisable("zkgwt")) {
            System.out.println(">>>>> OTHER: " + zFullQName);
            return null;
        }
        if (ZKGwtWidgetClassGenerator.isZkObject(wdClz)) {
            System.out.println(">>>>>WIDGET: [" + this.i++ + "]: " + zFullQName);
            for (String src : wdClz.getSrcPaths()) {
                System.out.println(">>>>>>>>>>: src-> " + src + " " + zFullQName);
            }
            SourceCodeNode parent = this.recursiveCreateSrcNode(wdClz, 0, root);
            SourceCodeNode leaf = new SourceCodeNode(wdClz.getClassName() + ".java", true);
            leaf.setContent(this.generateJavaContent(wdClz));
            leaf.setParent(parent);
            return leaf;
        }
        System.out.println(">>>>> OTHER: " + zFullQName);
        return null;
    }

    private static boolean isZkObject(ZkClass zClass) {
        Type superType = zClass.getSuperClass();
        if (superType == null) {
            return false;
        }
        LanguageContext context = zClass.getLangContext();
        String ori = superType.getOriginal();
        if ("zk.Object".equals(ori)) {
            return true;
        }
        ZkClass ancient = context.getZkClass(ori);
        return ZKGwtWidgetClassGenerator.isZkObject(ancient);
    }

    @Override
    protected SourceCodeNode generatePackageHtml(String package_, String textContent, SourceCodeNode root) {
        return null;
    }

    @Override
    protected String getTranslatedPackage(ZkClass aWidgetClass) {
        String clsPackage = aWidgetClass.getPackage();
        return "org.zkoss.gwt.client." + clsPackage;
    }

    private String generateJavaContent(ZkClass aWidgetClass) {
        StringBuffer sb = new StringBuffer();
        Strings.appendln(sb, "package ", this.getTranslatedPackage(aWidgetClass), ";");
        Strings.appendln(sb);
        Strings.appendln(sb, "import org.zkoss.gwt.client.zul.Widget;");
        Strings.appendln(sb, "import java.util.*;");
        Strings.appendln(sb, "import com.google.gwt.core.client.JavaScriptObject;");
        Strings.appendln(sb);
        this.generateClass(sb, aWidgetClass, "");
        return sb.toString();
    }

    private void generateClass(StringBuffer sb, ZkClass clazz, String pre) {
        Strings.append(sb, pre, "public class ", clazz.getClassName());
        Strings.append(sb, " extends ", clazz.getSuperClass().getTypeName());
        Strings.appendln(sb, pre, "{");
        this.generateCreate(sb, clazz, pre + "\t");
        Strings.appendln(sb);
        ZKGwtWidgetClassGenerator.generateMethods(sb, clazz.getMethods(), pre + "\t");
        Strings.appendln(sb, pre, "}");
    }

    private void generateCreate(StringBuffer sb, ZkClass clazz, String pre) {
        Strings.appendln(sb, pre, "protected native JavaScriptObject create() /*-{");
        Strings.appendln(sb, pre, "\treturn new $wnd.", clazz.getFullClassName(), "();");
        Strings.appendln(sb, pre, "}-*/;");
    }

    private static void generateMethods(StringBuffer sb, List<Method> widgetMethods, String pre) {
        for (Method method : widgetMethods) {
            new MethodGenHelper(sb, pre, method).generate();
        }
    }
}

