/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.gwt;

import com.potix.doc.archive.Type;
import com.potix.doc.archive.langxml.LanguageContext;
import com.potix.doc.archive.langxml.TypeFactory;

public class ZkGwtTypeFactory
implements TypeFactory {
    private final LanguageContext langContext;

    public ZkGwtTypeFactory(LanguageContext langContext) {
        this.langContext = langContext;
    }

    public Type getInstance(final String typeStr) {
        return new Type(){
            private final String _type;
            {
                this._type = typeStr;
            }

            public String getTypeName() {
                return ZkGwtTypeFactory.this.toGwtSuperClassName(this._type);
            }

            public String toString() {
                return this.getTypeName();
            }

            public boolean isEmpty() {
                return this._type.isEmpty();
            }

            public String getOriginal() {
                return this._type;
            }
        };
    }

    private String toGwtSuperClassName(String zSuperClassName) {
        if (zSuperClassName == null || zSuperClassName.isEmpty() || "zk.Object".equals(zSuperClassName)) {
            return "org.zkoss.gwt.client.zul.Widget";
        }
        if ("DOMElement".equals(zSuperClassName)) {
            return "com.google.gwt.user.client.Element";
        }
        if ("Array".equalsIgnoreCase(zSuperClassName)) {
            return "Widget[]";
        }
        if ("Offset".equals(zSuperClassName)) {
            return "int[]";
        }
        if (this.langContext.getZkClass(zSuperClassName) != null) {
            return "org.zkoss.gwt.client." + zSuperClassName;
        }
        return zSuperClassName;
    }
}

