/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.archive.JsTextContext;
import com.potix.doc.archive.ZkClass;
import com.potix.doc.js.ContainerFinder;
import com.potix.doc.js.Finders;
import com.potix.doc.js.TextChunk;
import java.util.List;

public abstract class AbstractClassFinder
extends ContainerFinder {
    protected String getPreffix() {
        return "Class";
    }

    protected void parseContent(String header, TextChunk self, TextChunk parent, JsTextContext jsContext) {
        Finders.parseSubChunk(self, jsContext);
        TextChunk commentChk = AbstractClassFinder.findClassComment(self);
        if (commentChk == null) {
            return;
        }
        boolean hasPrototype = header.indexOf("prototype") >= 0;
        String classCommentBody = commentChk.getTextContent();
        if (Finders.isClassDeclaration(classCommentBody)) {
            String className = this.initClassName(classCommentBody).trim();
            String classPackage = this.initPackage(classCommentBody).trim();
            ZkClass zClass = new ZkClass(className, classPackage, jsContext.getLangContext());
            zClass.loadClassChunk(self, hasPrototype);
            commentChk.setDesc(zClass.getFullClassName());
            self.setDesc(zClass.getFullClassName());
            jsContext.getLangContext().appendClass(zClass);
        }
        if (Finders.isPartialDeclaration(classCommentBody)) {
            String[] partials = Finders.findPartial(classCommentBody);
            StringBuffer sb = new StringBuffer();
            for (String str : partials) {
                sb.append(str + ",");
                int i = str.lastIndexOf(".");
                String className = str.trim();
                String classPackage = "";
                if (i >= 0) {
                    className = str.substring(i + 1).trim();
                    classPackage = str.substring(0, i).trim();
                }
                ZkClass zClass = new ZkClass(className, classPackage, jsContext.getLangContext());
                zClass.loadClassChunk(self, hasPrototype);
                jsContext.getLangContext().appendClass(zClass);
            }
            commentChk.setDesc(sb.toString());
            self.setDesc("partial of:" + sb.toString());
        }
    }

    private static TextChunk findClassComment(TextChunk self) {
        List<TextChunk> commentChks = self.findByType("Comment");
        if (commentChks.size() >= 1) {
            return commentChks.get(0);
        }
        return null;
    }

    protected String initClassName(String commentBody) {
        String className = Finders.findClassName(commentBody);
        return className;
    }

    protected String initPackage(String commentBody) {
        return Finders.findClassPackage(commentBody);
    }
}

