/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BracesCloseHelper {
    private static final Logger logger = Logger.getLogger(BracesCloseHelper.class);
    private static final Pattern commentCloserPtn = Pattern.compile("\\*/");
    private static final Pattern commentEndPtn = Pattern.compile("[\\r\\n]");

    public static int find(int start, String text) {
        int count = 0;
        char[] arr = text.toCharArray();
        int temp = 0;
        int i = start;
        while (i < arr.length) {
            int next = i + 1;
            if (next >= arr.length) {
                return -1;
            }
            char nextChar = arr[next];
            temp = i;
            char currentChar = arr[i];
            switch (currentChar) {
                case '{': {
                    ++count;
                    break;
                }
                case '}': {
                    i = next;
                    if (--count != 0) break;
                    return i;
                }
                case '\"': {
                    i = BracesCloseHelper.findEndDQuot(next, arr);
                    break;
                }
                case '\'': {
                    i = BracesCloseHelper.findEndQuot(next, arr);
                    break;
                }
                case '/': {
                    if (nextChar == '*') {
                        i = BracesCloseHelper.findCommentCloser(next, text);
                        break;
                    }
                    if (nextChar != '/') break;
                    i = BracesCloseHelper.findEndLine(next, text);
                }
            }
            if (temp != i) continue;
            i = next;
        }
        return -1;
    }

    private static int findCommentCloser(int start, String str) {
        Matcher match = commentCloserPtn.matcher(str);
        if (!match.find(start)) {
            throw new IllegalArgumentException("the content of this text has problem");
        }
        int end = match.end();
        logger.trace("FIND CommentCloser:" + start + "\n" + str.substring(start, end));
        return end;
    }

    private static int findEndLine(int start, String str) {
        Matcher match = commentEndPtn.matcher(str);
        if (!match.find(start)) {
            throw new IllegalArgumentException("the content of this text has problem");
        }
        int end = match.end();
        logger.trace("FIND commentEndPtn:" + start + "\n" + str.substring(start, end));
        return end;
    }

    private static int findEndQuot(int start, char[] arr) {
        boolean isNextCommented = false;
        for (int i = start; i < arr.length; ++i) {
            char word = arr[i];
            if (word == '\\') {
                isNextCommented = !isNextCommented;
                continue;
            }
            if (word == '\'') {
                if (arr[i - 1] == '\\' && isNextCommented) continue;
                return i + 1;
            }
            isNextCommented = false;
        }
        return -1;
    }

    private static int findEndDQuot(int start, char[] arr) {
        block3: for (int i = start; i < arr.length; ++i) {
            char word = arr[i];
            switch (word) {
                case '\"': {
                    if (arr[i - 1] == '^' || arr[i - 1] == '\\') continue block3;
                    return i + 1;
                }
            }
        }
        return -1;
    }
}

