/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.Consts;
import com.potix.doc.js.TextChunk;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentAttacher {
    private static final Logger logger = Logger.getLogger(CommentAttacher.class);

    public static boolean stickCommentToAnchor(String text, TextChunk anchor, List<TextChunk> comments) {
        TextChunk comment;
        LinkedList<TextChunk> arr = new LinkedList<TextChunk>();
        int currentOffset = anchor.start();
        for (TextChunk comment2 : comments) {
            if (comment2.end() > currentOffset) continue;
            arr.add(comment2);
        }
        if (arr.size() <= 0) {
            return false;
        }
        Collections.sort(arr, Consts.OFFSET_COMPARATOR_DESC);
        boolean flag = false;
        Iterator i$ = arr.iterator();
        while (i$.hasNext() && CommentAttacher.isEmptyBetween(currentOffset, comment = (TextChunk)i$.next(), text)) {
            anchor.add(comment);
            flag = true;
            comments.remove(comment);
            currentOffset = comment.start();
        }
        return flag;
    }

    public static LinkedList<TextChunk> getStickComment(String text, int currentOffset, List<TextChunk> comments) {
        TextChunk comment;
        LinkedList<TextChunk> arr = new LinkedList<TextChunk>();
        for (TextChunk comment2 : comments) {
            if (comment2.end() > currentOffset) continue;
            arr.add(comment2);
        }
        if (arr.size() <= 0) {
            return arr;
        }
        Collections.sort(arr, Consts.OFFSET_COMPARATOR_DESC);
        LinkedList<TextChunk> ans = new LinkedList<TextChunk>();
        Iterator i$ = arr.iterator();
        while (i$.hasNext() && CommentAttacher.isEmptyBetween(currentOffset, comment = (TextChunk)i$.next(), text)) {
            ans.add(comment);
            comments.remove(comment);
            currentOffset = comment.start();
        }
        return ans;
    }

    private static boolean isEmptyBetween(int currentOffset, TextChunk comment, String text) {
        String str = text.substring(comment.end(), currentOffset).trim();
        return str.length() == 0;
    }
}

