/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.archive.JsTextContext;
import com.potix.doc.js.IFinder;
import com.potix.doc.js.TextChunk;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentFinder
implements IFinder {
    private static final Logger logger = Logger.getLogger(CommentFinder.class);
    static final Pattern startPtn = Pattern.compile("/\\*\\*");
    static final Pattern endPtn = Pattern.compile("\\*+/");
    static final String pre = "Comment";

    @Override
    public List<TextChunk> find(String textBody, TextChunk parent, int baseOffset, JsTextContext jsContext) {
        LinkedList<TextChunk> all = new LinkedList<TextChunk>();
        Matcher startMa = startPtn.matcher(textBody);
        Matcher endMa = endPtn.matcher(textBody);
        boolean hasStart = startMa.find();
        if (startMa.hitEnd()) {
            return all;
        }
        boolean hasEnd = endMa.find(startMa.end());
        while (hasStart && hasEnd) {
            String chunkBody = textBody.substring(startMa.start(), endMa.end());
            TextChunk chunk = new TextChunk(pre, chunkBody, jsContext, baseOffset + startMa.start());
            if (parent != null) {
                parent.add(chunk);
            }
            all.add(chunk);
            hasStart = startMa.find(endMa.end());
            if (startMa.hitEnd()) break;
            hasEnd = endMa.find(startMa.end());
            if (!endMa.hitEnd()) continue;
            break;
        }
        return all;
    }
}

