/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommentHelper {
    static final Pattern startPtn = Pattern.compile("/\\*\\*");
    static final Pattern endPtn = Pattern.compile("\\*+/");
    static final Pattern lineStartPtn = Pattern.compile("//");
    static final Pattern lineEndPtn = Pattern.compile("[\\n]");
    private static final int NOT_FOUND = -1;

    public static int findCommentCloser(String textBody, int start) {
        return CommentHelper.findCloser(textBody, start, startPtn, endPtn);
    }

    public static int findCommentLineCloser(String textBody, int start) {
        return CommentHelper.findCloser(textBody, start, lineStartPtn, lineEndPtn);
    }

    public static int findCloser(String textBody, int start, Pattern startPtn, Pattern endPtn) {
        Matcher startMa = startPtn.matcher(textBody);
        Matcher endMa = endPtn.matcher(textBody);
        boolean hasStart = startMa.find(start);
        if (!hasStart) {
            return -1;
        }
        if (endMa.find(startMa.end())) {
            return endMa.end();
        }
        return -1;
    }
}

