/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.Strings;
import com.potix.doc.archive.JsTextContext;
import com.potix.doc.js.BracesCloseHelper;
import com.potix.doc.js.CommentAttacher;
import com.potix.doc.js.IFinder;
import com.potix.doc.js.IRegion;
import com.potix.doc.js.Region;
import com.potix.doc.js.TextChunk;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerFinder
implements IFinder {
    private static final Logger logger = Logger.getLogger(ContainerFinder.class);

    @Override
    public List<TextChunk> find(String text, TextChunk parent, int baseOffset, JsTextContext jsContext) {
        Matcher match = this.getHeaderPattern().matcher(text);
        LinkedList<TextChunk> all = new LinkedList<TextChunk>();
        while (match.find()) {
            int candidateOffset = baseOffset + match.start();
            LinkedList<TextChunk> attachedComments = CommentAttacher.getStickComment(jsContext.getTextContent(), candidateOffset, jsContext.getCommentChks());
            if (attachedComments.size() <= 0) continue;
            String header = match.group();
            IRegion headerBodyRegion = this.getHeaderBodyRegion(match.start(), match.end(), text);
            if (headerBodyRegion == null) continue;
            if (!headerBodyRegion.isValid()) {
                logger.error(jsContext.getJsFilePath() + " line[" + Strings.startAtLine(jsContext.getTextContent(), candidateOffset) + "]: Can not find end brace for this declaration");
                continue;
            }
            if (!this.isHeaderValid(header)) continue;
            String textContent = text.substring(headerBodyRegion.start(), headerBodyRegion.end());
            TextChunk self = new TextChunk(this.getPreffix(), textContent, jsContext, candidateOffset);
            self.addSubChunks(attachedComments);
            all.add(self);
            logger.debug(this.getClass().getSimpleName() + ":: Find a match at offset: " + candidateOffset);
            this.parseContent(header, self, parent, jsContext);
            parent.add(self);
        }
        return all;
    }

    protected IRegion getHeaderBodyRegion(int headerStart, int headerEnd, String text) {
        int braceStartIndex = text.indexOf("{", headerEnd);
        if (braceStartIndex < 0) {
            return null;
        }
        String strBetween = text.substring(headerEnd, braceStartIndex);
        if (!strBetween.trim().isEmpty()) {
            return null;
        }
        int endIndex = BracesCloseHelper.find(headerEnd, text);
        Region region = new Region(headerStart, endIndex);
        return region;
    }

    protected boolean isHeaderValid(String header) {
        return true;
    }

    protected abstract void parseContent(String var1, TextChunk var2, TextChunk var3, JsTextContext var4);

    protected abstract Pattern getHeaderPattern();

    protected abstract String getPreffix();
}

