/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.Strings;
import com.potix.doc.archive.JsTextContext;
import com.potix.doc.js.ContainerFinder;
import com.potix.doc.js.Finder;
import com.potix.doc.js.IRegion;
import com.potix.doc.js.TextChunk;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineFinder
extends ContainerFinder {
    private static final Logger logger = Logger.getLogger(DefineFinder.class);
    private static final String PTN_STR = "[\\r\\n][\\s]*[\\$\\w]*[\\s]*:[\\s]*[\\s\\r\\n]*";
    static Finder difnineFieldFinder = new Finder("DefineField", "[\\r\\n][\\s]*[\\$\\w]*[\\s]*:[\\s]*[\\s\\r\\n]*", null);

    @Override
    public List<TextChunk> find(String text, TextChunk parent, int baseOffset, JsTextContext jsContext) {
        Matcher match = this.getHeaderPattern().matcher(text);
        LinkedList<TextChunk> all = new LinkedList<TextChunk>();
        while (match.find()) {
            int candidateOffset = baseOffset + match.start();
            String header = match.group();
            IRegion headerBodyRegion = this.getHeaderBodyRegion(match.start(), match.end(), text);
            if (headerBodyRegion == null) continue;
            if (!headerBodyRegion.isValid()) {
                logger.error(jsContext.getJsFilePath() + " line[" + Strings.startAtLine(jsContext.getTextContent(), candidateOffset) + "]: Can not find end brace for this declaration");
                continue;
            }
            if (!this.isHeaderValid(header)) continue;
            String textContent = text.substring(headerBodyRegion.start(), headerBodyRegion.end());
            TextChunk self = new TextChunk(this.getPreffix(), textContent, jsContext, candidateOffset);
            all.add(self);
            logger.debug(this.getClass().getSimpleName() + ":: Find a match at offset: " + candidateOffset);
            this.parseContent(header, self, parent, jsContext);
            parent.add(self);
        }
        return all;
    }

    @Override
    protected void parseContent(String header, TextChunk self, TextChunk parent, JsTextContext jsContext) {
        difnineFieldFinder.find(self.getTextContent(), self, self.start(), jsContext);
    }

    @Override
    protected Pattern getHeaderPattern() {
        return Pattern.compile("[\\r\\n][\\s]*\\$define[\\s]*:");
    }

    @Override
    protected String getPreffix() {
        return "Define";
    }
}

