/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.archive.JsTextContext;
import com.potix.doc.js.CommentAttacher;
import com.potix.doc.js.IFinder;
import com.potix.doc.js.TextChunk;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Finder
implements IFinder {
    final Pattern ptn;
    final String pre;
    Pattern desc_Ptn;

    public Finder(String name, String regex, String descRegex) {
        this.ptn = Pattern.compile(regex);
        if (descRegex != null) {
            this.desc_Ptn = Pattern.compile(descRegex);
        }
        this.pre = name;
    }

    @Override
    public List<TextChunk> find(String text, TextChunk parent, int baseOffset, JsTextContext jsContext) {
        Matcher match = this.ptn.matcher(text);
        LinkedList<TextChunk> list = new LinkedList<TextChunk>();
        boolean flag = match.find();
        while (flag) {
            TextChunk self = new TextChunk(this.pre, match.group(), jsContext, baseOffset + match.start());
            if (CommentAttacher.stickCommentToAnchor(jsContext.getTextContent(), self, jsContext.getCommentChks())) {
                this.initDesc(self);
                parent.add(self);
                list.add(self);
            }
            flag = match.find();
        }
        return list;
    }

    private void initDesc(TextChunk self) {
        if (this.desc_Ptn == null) {
            return;
        }
        Matcher matcher = this.desc_Ptn.matcher(self.getTextContent());
        if (matcher.find()) {
            self.setDesc(matcher.group());
        }
    }
}

