/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.archive.JsTextContext;
import com.potix.doc.js.DefineFinder;
import com.potix.doc.js.Finder;
import com.potix.doc.js.FunctionFinder;
import com.potix.doc.js.IFinder;
import com.potix.doc.js.PropertyFinder;
import com.potix.doc.js.TextChunk;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Finders {
    private static final FunctionFinder funcFinder = new FunctionFinder();
    private static final DefineFinder defineFinder = new DefineFinder();
    private static final PropertyFinder classPropertyFinder = new PropertyFinder();
    private static final Finder commentFieldFinder = new Finder("Field", "[\\r\\n][\\s]*//[\\s]*[_a-zA-Z\\$][\\$\\w]*[\\s]*:", "[_a-zA-Z\\$][\\$\\w]*");
    private static final Finder commentFuncFinder = new Finder("Func", "[\\r\\n][\\s]*//[\\s]*[_a-zA-Z\\$][\\$\\w]*[\\s]*:[\\s]*function[\\s]*\\(\\)", "[_a-zA-Z\\$][\\$\\w]*");
    private static final IFinder[] ELEMENT_FINDERS = new IFinder[]{defineFinder, funcFinder, classPropertyFinder, commentFuncFinder, commentFieldFinder};
    public static final Pattern AT_IMPORT_PTN = Pattern.compile("[\\r\\n][\\s]*\\*[\\s]*\\@(import[\\s][\\w.\\*]+[\\s]*\\;)[\\r\\n]");
    public static final Pattern AT_CLASS_PTN = Pattern.compile("/\\*\\*[\\s]*\\@[\\s]*class[\\s]([\\w._]+)[\\s]*[\\r\\n]");
    public static final Pattern AT_PARTIAL_PTN = Pattern.compile("/\\*\\*[\\s]*\\@[\\s]*partial[\\s]([\\w._]+[\\,]?[\\s]*)+[\\r\\n]");
    public static final Pattern AT_PARTIAL_CLASS_PTN = Pattern.compile("/\\*\\*[\\s]*\\@[\\s]*partial[\\s]([\\w._\\,\\s]*)[\\r\\n]");

    public static void parseSubChunk(TextChunk self, JsTextContext jsContext) {
        for (IFinder finder : ELEMENT_FINDERS) {
            finder.find(self.getTextContent(), self, self.start(), jsContext);
        }
    }

    public static boolean isClassDeclaration(String commentBody) {
        Matcher match = AT_CLASS_PTN.matcher(commentBody);
        return match.find();
    }

    public static boolean isPartialDeclaration(String commentBody) {
        Matcher match = AT_PARTIAL_PTN.matcher(commentBody);
        return match.find();
    }

    public static String findClassName(String textContext) {
        Matcher match = AT_CLASS_PTN.matcher(textContext);
        if (match.find()) {
            String str;
            int index = (str = match.group(1)).lastIndexOf(".");
            return str.substring(index >= 0 ? index + 1 : 0);
        }
        return null;
    }

    public static String findClassPackage(String textContext) {
        String str;
        int index;
        Matcher match = AT_CLASS_PTN.matcher(textContext);
        if (match.find() && (index = (str = match.group(1)).lastIndexOf(".")) >= 0) {
            return str.substring(0, index);
        }
        return "";
    }

    public static String[] findPartial(String textContext) {
        Matcher match = AT_PARTIAL_CLASS_PTN.matcher(textContext);
        if (match.find()) {
            String str = match.group(1);
            return str.split("[\\,]");
        }
        return null;
    }
}

