/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.Consts;
import com.potix.doc.Printer;
import com.potix.doc.Strings;
import com.potix.doc.archive.JsTextContext;
import com.potix.doc.js.CommentFinder;
import com.potix.doc.js.IFinder;
import com.potix.doc.js.PackageFinder;
import com.potix.doc.js.PrototypeClassFinder;
import com.potix.doc.js.ReturnClassFinder;
import com.potix.doc.js.TextChunk;
import com.potix.doc.js.VirtualClassFinder;
import com.potix.doc.js.WidgetClassFinder;
import com.potix.doc.js.ZkCopyClassFinder;
import com.potix.doc.js.ZkOverrideClassFinder;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class JsTextContextParser {
    private static final Logger logger = Logger.getLogger(JsTextContextParser.class);
    private static final CommentFinder commentFinder = new CommentFinder();
    private static final Pattern IMPORT_Ptn = Pattern.compile("[\\r\\n][\\s]*\\*[\\s]*\\@(import[\\s][\\w.\\*]+[\\s]*\\;)[\\r\\n]");
    private static final IFinder[] CLASS_FINDERs = new IFinder[]{new WidgetClassFinder(), new PrototypeClassFinder(), new ZkCopyClassFinder(), new ZkOverrideClassFinder(), new ReturnClassFinder(), new VirtualClassFinder()};
    private static final PackageFinder packageFinder = new PackageFinder();

    public static boolean parseJsText(JsTextContext jsContext) {
        String textContent = jsContext.getTextContent();
        TextChunk wholeJsChk = new TextChunk("JS", jsContext.getTextContent(), jsContext, 0);
        List<TextChunk> unAttachedComments = commentFinder.find(textContent, null, 0, jsContext);
        Collections.sort(unAttachedComments, Consts.OFFSET_COMPARATOR);
        jsContext.setCommentChks(unAttachedComments);
        packageFinder.find(textContent, wholeJsChk, 0, jsContext);
        for (IFinder classFinder : CLASS_FINDERs) {
            classFinder.find(textContent, wholeJsChk, 0, jsContext);
        }
        jsContext.setClassChks(wholeJsChk.getSubTextChunks());
        Printer.printChunks(wholeJsChk.getSubTextChunks());
        if (wholeJsChk.findByType("Class").size() <= 0) {
            logger.warn(jsContext.getJsFilePath() + " [no class found in Javascript]");
            return false;
        }
        if (unAttachedComments.size() > 0) {
            logger.warn("You have unattatched Comments [" + unAttachedComments.size() + "] in Javascript File: " + jsContext.getJsFilePath());
            for (TextChunk rest : unAttachedComments) {
                logger.warn(jsContext.getJsFilePath() + " line: [" + Strings.startAtLine(jsContext.getTextContent(), rest.start()) + "] not-used Comment: " + JsTextContextParser.getFirstLine(rest.getTextContent()));
            }
        }
        return true;
    }

    private static String getFirstLine(String str) {
        int index = (str = str.trim()).indexOf("\n");
        index = index > 0 ? index : str.length();
        String ans = str.substring(0, index);
        return ans;
    }
}

