/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.archive.JsTextContext;
import com.potix.doc.js.CommentAttacher;
import com.potix.doc.js.IFinder;
import com.potix.doc.js.TextChunk;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageFinder
implements IFinder {
    private static final Pattern ptn = Pattern.compile("//zk[.]\\$package\\([\\s]*['\\\"]([\\w.\\$_]+)['\\\"][\\s]*\\)\\;");
    private static final String pre = "Package";

    @Override
    public List<TextChunk> find(String text, TextChunk parent, int baseOffset, JsTextContext jsContext) {
        Matcher match = ptn.matcher(text);
        LinkedList<TextChunk> list = new LinkedList<TextChunk>();
        boolean flag = match.find();
        while (flag) {
            TextChunk self = new TextChunk(pre, match.group(), jsContext, baseOffset + match.start());
            if (CommentAttacher.stickCommentToAnchor(jsContext.getTextContent(), self, jsContext.getCommentChks())) {
                List<TextChunk> comts = self.findByType("Comment");
                TextChunk chk = comts.get(0);
                jsContext.getLangContext().addPackageHtml(this.initPackageStr(text), PackageFinder.transformToHtml(chk.getTextContent()));
                parent.add(self);
                list.add(self);
            }
            flag = match.find();
        }
        return list;
    }

    private static String transformToHtml(String comt) {
        String ans = comt.replaceAll("/\\*", "\n");
        ans = ans.replaceAll("/\\*\\*", "\n");
        ans = ans.replaceAll("\\*/", "\n");
        ans = ans.replaceAll("[\\r\\n][\\s]*\\*", "\n");
        ans = "<html><body>" + ans + "</body></html>";
        return ans;
    }

    private final String initPackageStr(String content) {
        if (ptn == null) {
            return "";
        }
        Matcher matcher = ptn.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }
}

