/*
 * Decompiled with CFR 0.152.
 */
package com.potix.doc.js;

import com.potix.doc.archive.Comment;
import com.potix.doc.archive.JsTextContext;
import com.potix.doc.js.CommentAttacher;
import com.potix.doc.js.IFinder;
import com.potix.doc.js.TextChunk;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFinder
implements IFinder {
    private static final Logger logger = Logger.getLogger(PropertyFinder.class);
    private static final Pattern ptn = Pattern.compile("[\\r\\n][\\s]*[_a-zA-Z\\$][\\$\\w]*[\\s]*:");
    private static final Pattern desc_Ptn = Pattern.compile("[_a-zA-Z\\$][\\$\\w]*");

    @Override
    public List<TextChunk> find(String textbody, TextChunk parent, int baseOffset, JsTextContext jsContext) {
        Matcher match = ptn.matcher(textbody);
        boolean flag = match.find();
        while (flag) {
            TextChunk self = new TextChunk(null, match.group(), jsContext, baseOffset + match.start());
            if (CommentAttacher.stickCommentToAnchor(jsContext.getTextContent(), self, jsContext.getCommentChks())) {
                PropertyFinder.initDesc(self);
                TextChunk commentChk = self.findByType("Comment").get(0);
                Comment comt = new Comment(commentChk.getTextContent());
                if (comt.isField()) {
                    self.setType("Field");
                } else if (comt.isFunction()) {
                    self.setType("Func");
                } else {
                    logger.error("UNKNOWN property type:" + comt + self.getTextContent());
                }
                parent.add(self);
            }
            flag = match.find();
        }
        return null;
    }

    private static void initDesc(TextChunk self) {
        if (desc_Ptn == null) {
            return;
        }
        Matcher matcher = desc_Ptn.matcher(self.getTextContent());
        if (matcher.find()) {
            self.setDesc(matcher.group());
        }
    }
}

